import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';


@Injectable()
export class MatricsReportService {
    
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }
    

    getCouponsForAutocomplete(searchTerm, assocs): Observable<any> {
        return this.searchService.getObjects("", "All", {}, assocs, null, null, null, null)
                .map(
                    data => {
                        return this.utilsService.convertResponseToObjects(data, assocs);
                    }
                );
    }
    
}