package performa.ws;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import oneit.appservices.ws.JSONServiceRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.BaseBusinessClass;
import oneit.objstore.ObjectTransaction;
import oneit.utils.BusinessException;
import oneit.utils.MultiException;
import org.json.JSONException;
import org.json.JSONObject;
import performa.orm.Job;


public class SelectHiringTeamFP extends BaseSelectHiringTeamFP
{
    private static final long serialVersionUID  =   0L;
    public static LoggingArea LOG               =   LoggingArea.createLoggingArea("SelectHiringTeamFP");
    
    // This constructor should not be called
    public SelectHiringTeamFP ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    @Override
    public void processForm(JSONServiceRequest request, ObjectTransaction objTran, JSONObject result, MultiException exceptions, 
                                                Set<BaseBusinessClass> createdBBCs, Set<BaseBusinessClass> updatedBBCs) throws BusinessException, JSONException
    {
        HttpServletRequest  httpRequest =   request.getRequest();

        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Setting hiring team to the session ", getHiringTeam());
        
        httpRequest.getSession().setAttribute("SelectedHiringTeam", getHiringTeam());
    }
}

