
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class WorkFlowMessagePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea WorkFlowMessagePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "WorkFlowMessage");

    // Private attributes corresponding to business object data
    private String dummyDelay;
    private String dummyVariance;
    private Boolean dummyBusinessHoursOnly;
    private Boolean dummyIsWithdrawalMessage;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Delay = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Variance = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_BusinessHoursOnly = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsWithdrawalMessage = DefaultAttributeHelper.INSTANCE;
    



    public WorkFlowMessagePersistenceMgr ()
    {
        dummyDelay = (String)(HELPER_Delay.initialise (dummyDelay));
        dummyVariance = (String)(HELPER_Variance.initialise (dummyVariance));
        dummyBusinessHoursOnly = (Boolean)(HELPER_BusinessHoursOnly.initialise (dummyBusinessHoursOnly));
        dummyIsWithdrawalMessage = (Boolean)(HELPER_IsWithdrawalMessage.initialise (dummyIsWithdrawalMessage));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_work_flow_message.object_id as id, {PREFIX}tl_work_flow_message.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_work_flow_message.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_work_flow_message.delay, {PREFIX}tl_work_flow_message.variance, {PREFIX}tl_work_flow_message.business_hours_only, {PREFIX}tl_work_flow_message.is_withdrawal_message, {PREFIX}tl_work_flow_message.message_template_id, {PREFIX}tl_work_flow_message.work_flow_stage_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, WorkFlowMessage.REFERENCE_WorkFlowMessage);

                if (objectToReturn instanceof WorkFlowMessage)
                {
                    LogMgr.log (WorkFlowMessagePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a WorkFlowMessage");
                }
            }

            PersistentSet tl_work_flow_messagePSet = allPSets.getPersistentSet(id, "tl_work_flow_message", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_work_flow_messagePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_work_flow_messagePSet.containsAttrib(WorkFlowMessage.FIELD_Delay)||
                    !tl_work_flow_messagePSet.containsAttrib(WorkFlowMessage.FIELD_Variance)||
                    !tl_work_flow_messagePSet.containsAttrib(WorkFlowMessage.FIELD_BusinessHoursOnly)||
                    !tl_work_flow_messagePSet.containsAttrib(WorkFlowMessage.FIELD_IsWithdrawalMessage)||
                    !tl_work_flow_messagePSet.containsAttrib(WorkFlowMessage.SINGLEREFERENCE_MessageTemplate)||
                    !tl_work_flow_messagePSet.containsAttrib(WorkFlowMessage.SINGLEREFERENCE_WorkFlowStage))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (WorkFlowMessagePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                WorkFlowMessage result = new WorkFlowMessage ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_work_flow_message " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_work_flow_message.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (WorkFlowMessage.SINGLEREFERENCE_WorkFlowStage))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_work_flow_message " +
                            "WHERE " + SELECT_JOINS + "work_flow_stage_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_work_flow_messagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_message");
            

            
            if (tl_work_flow_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_work_flow_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_work_flow_message " +
                                                           "SET delay = ?, variance = ?, business_hours_only = ?, is_withdrawal_message = ?, message_template_id = ? , work_flow_stage_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_work_flow_message.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Delay.getForSQL(dummyDelay, tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.FIELD_Delay))).listEntry (HELPER_Variance.getForSQL(dummyVariance, tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.FIELD_Variance))).listEntry (HELPER_BusinessHoursOnly.getForSQL(dummyBusinessHoursOnly, tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.FIELD_BusinessHoursOnly))).listEntry (HELPER_IsWithdrawalMessage.getForSQL(dummyIsWithdrawalMessage, tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.FIELD_IsWithdrawalMessage))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.SINGLEREFERENCE_MessageTemplate)))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.SINGLEREFERENCE_WorkFlowStage)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_work_flow_message WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_work_flow_message", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (WorkFlowMessagePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_work_flow_message");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_work_flow_message for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (WorkFlowMessagePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_work_flow_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (WorkFlowMessagePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_work_flow_messagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_message");
        

        LogMgr.log (WorkFlowMessagePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_work_flow_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_work_flow_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_work_flow_message " +
                                                       "WHERE tl_work_flow_message.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_work_flow_message WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_work_flow_message");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_work_flow_message for row:" + objectID;

                    LogMgr.log (WorkFlowMessagePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_work_flow_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, WorkFlowMessage> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (WorkFlowMessage.REFERENCE_WorkFlowMessage.getObjectIDSpace (), r.getLong ("id"));
            WorkFlowMessage resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, WorkFlowMessage.REFERENCE_WorkFlowMessage);

                if (cachedElement instanceof WorkFlowMessage)
                {
                    LogMgr.log (WorkFlowMessagePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (WorkFlowMessage)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a WorkFlowMessage");
                }
            }
            else
            {
                PersistentSet tl_work_flow_messagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_message", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new WorkFlowMessage ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (WorkFlowMessagePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_work_flow_message " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (WorkFlowMessage.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_work_flow_message.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_work_flow_message.object_id is not null
                    String preFilter = "(tl_work_flow_message.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_work_flow_message " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_work_flow_messagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_message", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_work_flow_messagePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_work_flow_messagePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_work_flow_messagePSet.setAttrib(WorkFlowMessage.FIELD_Delay, HELPER_Delay.getFromRS(dummyDelay, r, "delay"));
        tl_work_flow_messagePSet.setAttrib(WorkFlowMessage.FIELD_Variance, HELPER_Variance.getFromRS(dummyVariance, r, "variance"));
        tl_work_flow_messagePSet.setAttrib(WorkFlowMessage.FIELD_BusinessHoursOnly, HELPER_BusinessHoursOnly.getFromRS(dummyBusinessHoursOnly, r, "business_hours_only"));
        tl_work_flow_messagePSet.setAttrib(WorkFlowMessage.FIELD_IsWithdrawalMessage, HELPER_IsWithdrawalMessage.getFromRS(dummyIsWithdrawalMessage, r, "is_withdrawal_message"));
        
        tl_work_flow_messagePSet.setAttrib(WorkFlowMessage.SINGLEREFERENCE_MessageTemplate, r.getObject ("message_template_id"));
        tl_work_flow_messagePSet.setAttrib(WorkFlowMessage.SINGLEREFERENCE_WorkFlowStage, r.getObject ("work_flow_stage_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_work_flow_messagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_message");
        

        
        if (tl_work_flow_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_work_flow_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_work_flow_message " +
                                     "  (delay, variance, business_hours_only, is_withdrawal_message,  message_template_id, work_flow_stage_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Delay.getForSQL(dummyDelay, tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.FIELD_Delay))).listEntry (HELPER_Variance.getForSQL(dummyVariance, tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.FIELD_Variance))).listEntry (HELPER_BusinessHoursOnly.getForSQL(dummyBusinessHoursOnly, tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.FIELD_BusinessHoursOnly))).listEntry (HELPER_IsWithdrawalMessage.getForSQL(dummyIsWithdrawalMessage, tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.FIELD_IsWithdrawalMessage))) .listEntry (SQLManager.CheckNull((Long)(tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.SINGLEREFERENCE_MessageTemplate)))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_messagePSet.getAttrib (WorkFlowMessage.SINGLEREFERENCE_WorkFlowStage)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_work_flow_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
