package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.BusinessException;
import performa.orm.*;

/**
 *
 * @author Harsh
 */
public class ChangeAssessmentCriteriaFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   (Job) request.getAttribute("Job");

        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside ChangeAssessmentCriteriaFP for ", job, " Include Assessment:", job.getIncludeAssessmentCriteria());
        
        if(!job.isTrue(job.getIncludeAssessmentCriteria()))
        {
            for(AssessmentCriteria assessmentCriteria : job.getAssessmentCriteriasSet())
            {
                assessmentCriteria.delete();
            }
        }
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "ChangeAssessmentCriteriaFP completed for ", job);
        
        return RedisplayResult.getInstance();
    }
}
