import { Injectable } from '@angular/core';
import { RequestOptions, Headers, Response } from '@angular/http';
import { HttpClient, HttpHeaders, HttpParams, HttpRequest } from '@angular/common/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/switchMap';
import 'rxjs/add/operator/catch';
import 'rxjs/add/observable/throw';
import { environment } from '../../../environments/environment'

@Injectable()
export class ApiService {

    apiBase: string;
    debounceTime: number;

    constructor(
        private httpClient: HttpClient
    ) {
        this.apiBase = environment.baseUrl; //fetch this using environments;
    }

    get(url: string): Observable<any> {
        let apiURL = this.apiBase + url;
        return this.httpClient.get(apiURL).map(res => res);
    }

    post(url: string, param?): Observable<any> {
        let apiURL = this.apiBase + url;
        return this.httpClient.post(apiURL, param).map(res => res);
    }

    put(url: string, param?): Observable<any> {
        let apiURL = this.apiBase + url;
        return this.httpClient.patch(apiURL, param).map(res => res);
    }

    delete(url: string): Observable<any> {
        let apiURL = this.apiBase + url;
        return this.httpClient.delete(apiURL).map(res => res);
    }

    postBlobRequest(url: string, param?): Observable<any> {
        let apiURL = this.apiBase + url;
        return this.httpClient.post(
            apiURL, param, {
                responseType: 'blob',
                observe: 'response' //When this is not defined, it will directly return only BLOB
            }
        ).map(res => ({ content: res.body }));
    }
}