import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs/operators';
import { AuthService } from '../../services/auth.service';
import { Router } from '@angular/router';
import { BaseComponent } from '../../base/base.component';
import { EXTERNAL_LINKS } from '../../config/constants';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { CareerProfileModel } from '../../models/career-profile.model';
import { environment } from '../../../../environments/environment';

@Component({
    selector: 'app-left-sidebar',
    templateUrl: './left-sidebar.component.html',
    styleUrls: ['./left-sidebar.component.scss']
})
export class LeftSidebarComponent extends BaseComponent implements OnInit {

    year = new Date().getFullYear();
    showPremium = false;
    careerProfile = new CareerProfileModel();
    unassumeLink  = `${environment.baseUrl}unassume_mc.jsp`;

    constructor(
        private authService: AuthService,
        private router: Router,
        private personalDetailsService: PersonalDetailsService
    ) {
        super();
    }

    ngOnInit(): void {
        this.personalDetailsService.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.careerProfile = response;
        });
    }

    logout(): void {
        this.isLoading = true;
        this.authService.logout()
            .pipe(takeUntil(this.componentInView))
            .subscribe(() => {
                this.router.navigate(['/my-career-web/auth/login']);
                this.isLoading = false;
            });
    }

    openPrivacyPolicy(): void {
        window.open(EXTERNAL_LINKS.PRIVACY_POLICY, '_blank')
    }

}
