import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SearchService } from './../../oneit/services/search.service';
import { SearchMessageTemplatesService } from './search-message-templates.service';

import { SearchMessageTemplate } from './search-message-templates.model';

@Component({
    selector: 'app-search-message-templates',
    templateUrl: './search-message-templates.component.html'
})
export class SearchMessageTemplatesComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    searchMessageTemplate : SearchMessageTemplate = new SearchMessageTemplate();
    messageTemplates: any[] = [];
    showResults: boolean = false;
    s: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private searchService: SearchService,
        private appService: AppService,
        private searchMessageTemplatesService: SearchMessageTemplatesService
    ){
        
    }

    ngOnInit() {

        this.searchService.getLastSearchRequest("SearchMessageTemplate").subscribe(
            data => {
                if (data != null) {
                    this.searchMessageTemplate = data.queryParams;
                    this.getMessageTemplates(false);
                }
            }
        );
        this.gets();
    }
    

    gets() {
        this.subscriptions.push(this.searchMessageTemplatesService.getDummy51s([])
            .subscribe(
                data => {
                    this.s = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    getMessageTemplates(saveSearch: boolean) {
        
        this.showResults    =   true;
        this.showLoader     =   true;
        let assocs          =   [];
        
        this.subscriptions.push(this.searchMessageTemplatesService.getMessageTemplates(this.searchMessageTemplate, assocs, saveSearch)
            .subscribe(
                data => {
                    this.messageTemplates = data;
                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
        
    onRowSelect(data) {
        this.router.navigate(['/XXXX', data.ObjectID]);
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}