<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
 
<oneit:dynIncluded>
<%
    //TODO: filter with Client;
    SecUser secUser =   SecUser.getTXUser(transaction);

    //to verify social login and redirect to login verification
    if(secUser.hasRole(Utils.ROLE_CLIENT))
    {
        CompanyUser companyUser =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);

        if(companyUser!=null)
        {
            if(companyUser.isLoggedViaSocial() && companyUser.getIsAccountVerified()!=Boolean.TRUE)
            {
                response.sendRedirect(WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.COMPANY_ACCOUNT_VERIFICATION).getLink(request));
                return;
            }
            
            //to notify email address change still not verified
            if(request.getSession().getAttribute("EmailStillNotVerified")!=null)
            {
                response.sendRedirect(WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.MY_DETAILS).getLink(request));
                return;
            }
            
            //to notify email address changed
            if(request.getSession().getAttribute("EmailVerified")!=null)
            {
                request.getSession().removeAttribute("EmailVerified");
                request.setAttribute(NotificationUtils.NOTIFICATION_MSG_PARAM, "emailChangeVefified");
                
                String  messageId   =   NotificationUtils.getNotifyIdIfRequired(process, request);
                String  link        =   WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.MY_DETAILS).getLink(request);
                
                response.sendRedirect(NotificationUtils.appendNotifyIDToURL(link, messageId));
                return;
            }
        }
    }

    CompanyUser companyUser     =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    HiringTeam  hiringTeam      =   companyUser.getSelectedTeam();
    HiringTeam  billingTeam     =   hiringTeam.getManageOwnBilling() ? hiringTeam : hiringTeam.getBilledByTeam();
    SearchHome  searchHome      =   (SearchHome) RunSearchExecutorFP.setupExecutor(request, SearchHome.REFERENCE_SearchHome, true);
    Job[]       allJobs         =   (Job[])process.getAttribute("allJobs");
    RoleType    userRole        =   companyUser.getRoleForHiringTeam(hiringTeam);

    searchHome.setHiringTeam(hiringTeam);
    searchHome.setCompanyUser(companyUser);

    if(allJobs == null)
    {
        allJobs    =   (Job[]) searchHome.doSearch();
    }

    Job[]   jobs            =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(JobStatus.OPEN))
                                                .andHiringTeam(new EqualsFilter<>(hiringTeam))
                                                .search(transaction);

    List<Job>   recentJobs  =   ObjstoreUtils.sort(Arrays.asList(allJobs), 
                                                new ObjectTransform[]{  Job.pipesJob().toLastEdited() ,
                                                                        Job.pipesJob().toObjectLastModified()}, 
                                                new Comparator[]{ CollectionUtils.reverse(CollectionUtils.DEFAULT_COMPARATOR), CollectionUtils.reverse(CollectionUtils.DEFAULT_COMPARATOR), CollectionUtils.reverse(CollectionUtils.DEFAULT_COMPARATOR) });
    
    Article jobsArticle     =   WebUtils.getArticleByShortCut(transaction, WebUtils.JOBS);
    Article companyArticle  =   WebUtils.getArticleByShortCut(transaction, WebUtils.MY_COMPANY);
    String  nextPage        =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.VIEW_APPLICANTS).toMap());
    String  shortlistPage   =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.APPLICANTS_SHORTLIST).toMap());
    String  homePage        =   WebUtils.getSamePageInRenderMode(request, "Page");
    String  jobsPage        =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "Page").toMap());
    boolean firstTime       =   request.getParameter("firstTime") != null ? Boolean.parseBoolean(request.getParameter("firstTime")) : false;
    boolean hasBillingSetup =   hiringTeam.hasBillingSetup();
    boolean canCreateJob    =   hiringTeam.allowJobCreation();

%>

    <style>
        #overlay {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0,0,0,0.5);
            z-index: 99999;
            cursor: pointer;
        }
        .welcome-pop-top {
            margin-top: 20%;
        }
        .main-welcome-popup h2 {
            padding: 0 20px 0;
        }
    </style>

    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc ($("form#editJob"), {'recalcOnError':true});
            
            $(".switch input[type='checkbox']").change(function() {
                $("button[name$='search']").click();
            });
        });
    </script>
    
    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
        <div class="dashboard-content-area">
        <div class="dashboard-first-part">
            <div class="welcome-box">
                <div class="dashboard-welcome">
                    <div class="welcome-text"> Welcome <br/> <%= firstTime ? "" : "back"%> <oneit:toString   value="<%= secUser.getFirstName()!=null ? secUser.getFirstName() : secUser.getUserName()%>"  mode="EscapeHTML"/>!</div>
                    <a class="d-create-job-btn <%= hasBillingSetup ? "" : "disabled"%>" href="<%= canCreateJob ? jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.START_JOB).toMap()) : "javascript:void(0);" %>" onclick="<%= canCreateJob ? "" : "showReachedCap()"%>">Create a Job</a>
                </div>
                <div class="col-sm-3 col-xs-12 d-three-box green-light">
                    <div class="d-fl-left eq-height">
                        <div class="dash-count c-green">
                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobStatus", JobStatus.OPEN).toMap())
                                                                            .toMap() %>">
                                <oneit:toString value="<%= jobs.length %>"  mode="EscapeHTML"   nullValue="0"/>
                            </oneit:button>
                        </div>
                        <div class="d-box-title">Open Jobs</div>
                        <%
                            int closingSoonJobs =   Utils.getClosingSoonJobCount(jobs);
                            
                            if(closingSoonJobs > 0)
                            {
                        %>
                                <oneit:button   value=" "   name="navigateBetweenStatus"    skin="link"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                                                .mapEntry("JobStatus", JobStatus.OPEN)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobSortOption", JobSortOption.CLOSING_SOON).toMap())
                                                                                .toMap() %>">
                                    <div class="arrow-btn">
                                        <oneit:toString value="<%= closingSoonJobs %>"  mode="Integer"  nullValue="0"/> closing soon 
                                    </div>
                                </oneit:button>
                        <%
                            }
                            else
                            {
                        %>
                                <div class="empty-area">&nbsp;</div>
                        <%
                            }
                        %>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-12 d-three-box gray-light">
                    <div class="d-fl-left eq-height">
                        <div class="dash-count c-gray">
                        <%
                            Job[]   filledJobs  =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(JobStatus.FILLED))
                                                                    .andHiringTeam(new EqualsFilter<>(hiringTeam))
                                                                    .search(transaction);
                            int     filledCount =   filledJobs != null ? filledJobs.length : 0;
                                    
                            if(filledCount > 0)
                            {
                        %>
                                <oneit:button   value=" "   name="navigateBetweenStatus"    skin="link"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                                                .mapEntry("JobStatus", JobStatus.FILLED)
                                                                                .toMap() %>">
                                        <oneit:toString value="<%= filledCount %>"  mode="Integer"  nullValue="0"/>
                                </oneit:button>
                        <%
                            }
                        %>
                            <%= filledCount == 0 ? "0" : "" %>
                        </div>
                        <div class="d-box-title">Jobs filled</div>
                        <div class="empty-area">&nbsp;</div>
                    </div>
                </div>
            </div>
        </div>
        <div class="second-part">
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            <div class="d-job-title">Your Open Jobs
                <div class="pull-right show-all-jobs-toggle">
                    <span>Show all open jobs for team</span>
                    <span >
                        <label class="switch">
                            <oneit:recalcClass  htmlTag="span"  classScript="searchHome.getShowAllJobs() ? 'checkbox checked': 'checkbox unchecked'"    searchHome="<%= searchHome %>">
                                <oneit:ormInput obj="<%= searchHome %>" attributeName="ShowAllJobs"   type="checkbox"/>
                            </oneit:recalcClass>
                            <div class="slider round"></div>
                        </label>
                        <oneit:button   value="Search"    name="search"    cssClass="hide"/>
                    </span>
                </div>
            </div>
            <%
                if(recentJobs.isEmpty())
                {
            %>
                    No jobs available.
            <%
                }
                else
                {
            %>
                    <oneit:dynInclude   page="/extensions/adminportal/inc/job_list.jsp" data="<%= CollectionUtils.EMPTY_MAP%>"  ShortlistPage="<%= shortlistPage %>"
                                        NextPage="<%= nextPage%>"   HomePage="<%= homePage%>"   CanCreateJob="<%= canCreateJob %>"   
                                        Jobs="<%=  CollectionUtils.batch(recentJobs, 10).get(0).toArray(new Job[0]) %>"/>
            <%
                }
            %>
        </div> 
        </div>
    </oneit:form>
    <%
        if(billingTeam.getCardID() == null)
        {
    %>
            <oneit:form name="setupBilling" method="post"    enctype="multipart/form-data">
                <div id="overlay">
                    <div class="modal-dialog welcome-pop-top">
                        <div class="modal-body main-welcome-popup">
                            <h2>You haven't set up billing yet!</h2>
                            <%
                                if(userRole == RoleType.STANDARD)
                                {
                            %>                            
                                    <p>Please contact your Administrator to set up billing</p>
                            <%
                                }
                                else
                                {
                            %>                            
                                    <p>Please set up billing details before creating jobs.</p>
                                    <div class="create-y-f-job">
                                        <oneit:button   value=" "    name="gotoPage"    skin="link"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", companyArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "Billing").toMap()))
                                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("HiringTeam", hiringTeam).toMap())
                                                                                            .toMap() %>">
                                            Setup Billing
                                        </oneit:button>
                                    </div>
                            <%
                                }
                            %>                            
                        </div>          
                    </div>
                </div>
            </oneit:form>

    <%
        }
        else if(billingTeam.getIsPPJ() == null || (!billingTeam.getIsPPJ() && billingTeam.getPaymentPlan() == null))
        {
    %>
    
            <oneit:form name="setupPlan" method="post"    enctype="multipart/form-data">
                <div id="overlay">
                    <div class="modal-dialog welcome-pop-top">
                        <div class="modal-body main-welcome-popup">
                            <h2>You haven't set up a payment plan yet!</h2>
                            <%
                                if(userRole == RoleType.STANDARD)
                                {
                            %>                            
                                    <p>Please contact your Administrator to set up a plan</p>
                            <%
                                }
                                else
                                {
                            %>                            
                                    <p>Please select a payment plan before creating jobs</p>
                                    <div class="create-y-f-job">
                                        <oneit:button   value=" "    name="gotoPage"    skin="link"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", companyArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "ManagePlan").toMap()))
                                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("HiringTeam", hiringTeam).toMap())
                                                                                            .toMap() %>">
                                            Setup Payment Plan
                                        </oneit:button>
                                    </div>
                            <%
                                }
                            %>       
                        </div>          
                    </div>
                </div>
            </oneit:form>
    <%
        }
    %>
    <!-- not using -->
    <div class="modal fade" id="welcomepopup" role="dialog">
        <div class="modal-dialog welcome-pop-top">
            <div class="modal-body main-welcome-popup">
                <h2>Welcome to your Dashboard!</h2>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a porta ex, ac suscipit quam. Donec aliquam hendrerit odio, et vestibulum turpis porttitor u phasellus nec velit in nibh eleifend.</p>
                <div class="create-y-f-job">
                    <a href="<%= jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.CREATE_JOB).toMap()) %>">
                        Create your first job
                    </a>
                </div>
            </div>          
        </div>
    </div>
</oneit:dynIncluded>