import { Component, EventEmitter, OnInit, Output } from '@angular/core';
import { BaseComponent } from '../../../base/base.component';
import { CareerProfileModel } from '../../../models/career-profile.model';
import { PersonalDetailsService } from '../../../services/personal-details.service';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { takeUntil } from 'rxjs/operators';
import { environment } from '../../../../../environments/environment';
import { SaveService } from '../../../../oneit/services/save.service';

@Component({
    selector: 'app-templates',
    templateUrl: './templates.component.html',
    styleUrls: ['./templates.component.scss']
})
export class TemplatesComponent extends BaseComponent implements OnInit {

    assocs = ['Candidate', 'Candidate.CandidateTemplates'];
    careerProfile = new CareerProfileModel();
    tempalteStatus = {
        INCLUDED_IN_FREE: 'INCLUDED_IN_FREE',
        INCLUDED_IN_PREMIUM: 'INCLUDED_IN_PREMIUM',
    };
    templatesShown = false;
    apiBase = environment.baseUrl;
    @Output() careerProfileLoaded = new EventEmitter<CareerProfileModel>();

    constructor(
        private personalDetailsService: PersonalDetailsService,
        private saveService: SaveService,
        private utilsService: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.personalDetailsService.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.careerProfile = response;
                this.updatedObjs[this.careerProfile.ObjectID] = this.careerProfile;
                if (this.careerProfile.Candidate.AllTempletes) {
                    this.careerProfile.Candidate.AllTempletes.map(t => {
                        t.CanUse = t.Availability === this.tempalteStatus.INCLUDED_IN_FREE
                            || t.Availability === this.tempalteStatus.INCLUDED_IN_PREMIUM;
                        t.ImgPath = this.apiBase + t.FullImageURI
                    });
                    this.careerProfile.Candidate.AllTempletes.sort((t1, t2) => t1.SortOrder - t2.SortOrder);
                }
                this.careerProfileLoaded.emit(this.careerProfile);
            }, err => {
                this.isLoading = false;
                this.utilsService.handleError(err);
            })
    }

    selectTemplate(template): void {
        this.careerProfile.Template = template;
        this.isLoading = true;
        this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(() => {
                this.isLoading = false;
                this.templatesShown = false;
            });
    }

    showTemplates(): void {
        this.templatesShown = true;
    }

}
