import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { YourExperienceService } from './your-experience.service';


@Component({
    selector: 'app-your-experience',
    templateUrl: './your-experience.component.html'
})
export class YourExperienceComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private yourExperienceService: YourExperienceService
    ){
        
    }

    ngOnInit() {
    }
    
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}