package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.*;
import performa.orm.AssessmentCriteria;
import performa.orm.AssessmentCriteriaTemplate;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class SaveRequirementsTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        final   HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        Job                         job         =   (Job) request.getAttribute("Job");
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside SaveRequirementsTemplateFP for create new template.", job);
            
        objTran.runInNewTX((ObjectTransaction newObjTran) -> {
            
            AssessmentCriteriaTemplate newTemplate  =   AssessmentCriteriaTemplate.createAssessmentCriteriaTemplate(newObjTran);
            
            newTemplate.setUser(SecUser.getTXUser(newObjTran));
            newTemplate.setTemplateName(job.getAssessmentTemplateName());
            
            for (AssessmentCriteria criteria : job.getAssessmentCriteriasSet())
            {
                AssessmentCriteria criteriaCopy = AssessmentCriteria.createAssessmentCriteria(newObjTran);
            
                criteriaCopy.copyAttributesFrom(criteria);

                newTemplate.addToAssessmentCriterias(criteriaCopy);
            }
        });
        
        job.setAssessmentTemplateName(null);
        job.setSaveAssessmentTemplate(Boolean.FALSE);
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "SaveRequirementsTemplateFP completed for create new template.", job);
        
        return RedisplayResult.getInstance();
    }

    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   (Job) request.getAttribute("Job");
        
        BusinessObjectParser.assertFieldCondition(job.getAssessmentTemplateName() != null, job , Job.FIELD_AssessmentTemplateName, "mandatory", exceptions, true, request);

        super.validate(process, submission, exceptions, params);
    }
}