
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import oneit.security.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class CompanyUserPersistenceMgr extends SecUserExtensionPersistenceMgr
{
    private static final LoggingArea CompanyUserPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "CompanyUser");

    // Private attributes corresponding to business object data
    private Date dummyForgotPasswordMailSendDate;
    private String dummyForgotPasswordKey;
    private RoleType dummyRole;
    private Set<RoleType> dummyRoles;
    private String dummyPhone;
    private Date dummyVerificationMailSendDate;
    private String dummyVerificationKey;
    private Boolean dummyIsAccountVerified;
    private Boolean dummyIsEmailChanged;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_ForgotPasswordMailSendDate = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ForgotPasswordKey = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_Role = new EnumeratedAttributeHelper (RoleType.FACTORY_RoleType);
    private static final DelimitedEnumsAttributeHelper HELPER_Roles = new DelimitedEnumsAttributeHelper (RoleType.FACTORY_RoleType);
    private static final DefaultAttributeHelper HELPER_Phone = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_VerificationMailSendDate = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_VerificationKey = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsAccountVerified = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsEmailChanged = DefaultAttributeHelper.INSTANCE;
    



    public CompanyUserPersistenceMgr ()
    {
        dummyForgotPasswordMailSendDate = (Date)(HELPER_ForgotPasswordMailSendDate.initialise (dummyForgotPasswordMailSendDate));
        dummyForgotPasswordKey = (String)(HELPER_ForgotPasswordKey.initialise (dummyForgotPasswordKey));
        dummyRole = (RoleType)(HELPER_Role.initialise (dummyRole));
        dummyRoles = (Set<RoleType>)(HELPER_Roles.initialise (dummyRoles));
        dummyPhone = (String)(HELPER_Phone.initialise (dummyPhone));
        dummyVerificationMailSendDate = (Date)(HELPER_VerificationMailSendDate.initialise (dummyVerificationMailSendDate));
        dummyVerificationKey = (String)(HELPER_VerificationKey.initialise (dummyVerificationKey));
        dummyIsAccountVerified = (Boolean)(HELPER_IsAccountVerified.initialise (dummyIsAccountVerified));
        dummyIsEmailChanged = (Boolean)(HELPER_IsEmailChanged.initialise (dummyIsEmailChanged));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}oneit_sec_user_extension.object_id as id, {PREFIX}oneit_sec_user_extension.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}oneit_sec_user_extension.object_CREATED_DATE as CREATED_DATE, {PREFIX}oneit_sec_user_extension.object_TYPE as OBJECT_TYPE, {PREFIX}oneit_sec_user_extension.forgot_password_mail_send_date, {PREFIX}oneit_sec_user_extension.forgot_password_key, {PREFIX}oneit_sec_user_extension.role_type, {PREFIX}oneit_sec_user_extension.roles, {PREFIX}oneit_sec_user_extension.phone, {PREFIX}oneit_sec_user_extension.verification_mail_send_date, {PREFIX}oneit_sec_user_extension.verification_key, {PREFIX}oneit_sec_user_extension.is_account_verified, {PREFIX}oneit_sec_user_extension.is_email_changed, {PREFIX}oneit_sec_user_extension.user_id, {PREFIX}oneit_sec_user_extension.company_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, CompanyUser.REFERENCE_CompanyUser);

                if (objectToReturn instanceof CompanyUser)
                {
                    LogMgr.log (CompanyUserPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a CompanyUser");
                }
            }

            PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(id, "oneit_sec_user_extension", PersistentSetStatus.FETCHED);
            
            String  objectType = null;

             // Check for persistent sets already prefetched
            if (false ||
                    !oneit_sec_user_extensionPSet.containsAttrib("OBJECT_TYPE") || !oneit_sec_user_extensionPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_ForgotPasswordMailSendDate)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_ForgotPasswordKey)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_Role)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_Roles)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_Phone)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_VerificationMailSendDate)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_VerificationKey)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_IsAccountVerified)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.FIELD_IsEmailChanged)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.SINGLEREFERENCE_User)||
                    !oneit_sec_user_extensionPSet.containsAttrib(CompanyUser.SINGLEREFERENCE_Company))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (CompanyUserPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Polymorphic */
                objectType = (String)(oneit_sec_user_extensionPSet.getAttrib("OBJECT_TYPE"));

                if (context.getReferenceObject (CompanyUser.REFERENCE_CompanyUser, objectType) != CompanyUser.REFERENCE_CompanyUser)
                {
                    idsToFetch.add (id.longValue());
                }
                else
                {
                    CompanyUser result = new CompanyUser ();

                    result.setFromPersistentSets(id, allPSets);
                    context.addRetrievedObject(result);

                    results.add (result);
                }
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}oneit_sec_user_extension " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}oneit_sec_user_extension.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (CompanyUser.SINGLEREFERENCE_User))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}oneit_sec_user_extension " +
                            "WHERE " + SELECT_JOINS + "user_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (CompanyUser.SINGLEREFERENCE_Company))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}oneit_sec_user_extension " +
                            "WHERE " + SELECT_JOINS + "company_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension");
            

            
            if (oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}oneit_sec_user_extension " +
                                                           "SET forgot_password_mail_send_date = ?, forgot_password_key = ?, role_type = ?, roles = ?, phone = ?, verification_mail_send_date = ?, verification_key = ?, is_account_verified = ?, is_email_changed = ?, user_id = ? , company_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE oneit_sec_user_extension.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_ForgotPasswordMailSendDate.getForSQL(dummyForgotPasswordMailSendDate, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_ForgotPasswordMailSendDate))).listEntry (HELPER_ForgotPasswordKey.getForSQL(dummyForgotPasswordKey, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_ForgotPasswordKey))).listEntry (HELPER_Role.getForSQL(dummyRole, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_Role))).listEntry (HELPER_Roles.getForSQL(dummyRoles, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_Roles))).listEntry (HELPER_Phone.getForSQL(dummyPhone, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_Phone))).listEntry (HELPER_VerificationMailSendDate.getForSQL(dummyVerificationMailSendDate, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_VerificationMailSendDate))).listEntry (HELPER_VerificationKey.getForSQL(dummyVerificationKey, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_VerificationKey))).listEntry (HELPER_IsAccountVerified.getForSQL(dummyIsAccountVerified, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_IsAccountVerified))).listEntry (HELPER_IsEmailChanged.getForSQL(dummyIsEmailChanged, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_IsEmailChanged))).listEntry (SQLManager.CheckNull((Long)(oneit_sec_user_extensionPSet.getAttrib (CompanyUser.SINGLEREFERENCE_User)))).listEntry (SQLManager.CheckNull((Long)(oneit_sec_user_extensionPSet.getAttrib (CompanyUser.SINGLEREFERENCE_Company)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}oneit_sec_user_extension WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "oneit_sec_user_extension", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (CompanyUserPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "oneit_sec_user_extension");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:oneit_sec_user_extension for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (CompanyUserPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                oneit_sec_user_extensionPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (CompanyUserPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension");
        

        LogMgr.log (CompanyUserPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}oneit_sec_user_extension " +
                                                       "WHERE oneit_sec_user_extension.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}oneit_sec_user_extension WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "oneit_sec_user_extension");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:oneit_sec_user_extension for row:" + objectID;

                    LogMgr.log (CompanyUserPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            oneit_sec_user_extensionPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    public ResultSet executeSearchQueryAllCompanyUsers (SQLManager sqlMgr, SecUserExtension ReferenceExtension) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAllCompanyUsers");
    }
    public ResultSet executeSearchQueryIdPin (SQLManager sqlMgr, Long ID, String Pin) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryIdPin");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, CompanyUser> results = new LinkedHashMap ();
        
        MultiHashtable<String,ObjectID>   needsRefetch = new MultiHashtable ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (CompanyUser.REFERENCE_CompanyUser.getObjectIDSpace (), r.getLong ("id"));
            CompanyUser resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, CompanyUser.REFERENCE_CompanyUser);

                if (cachedElement instanceof CompanyUser)
                {
                    LogMgr.log (CompanyUserPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (CompanyUser)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a CompanyUser");
                }
            }
            else
            {
                PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                
                    String  objectType = (String)(oneit_sec_user_extensionPSet.getAttrib("OBJECT_TYPE"));

                    if (context.getReferenceObject (CompanyUser.REFERENCE_CompanyUser, objectType) != CompanyUser.REFERENCE_CompanyUser)
                    {
                        needsRefetch.add (objectType, objectID); // We will fetch these later
                        resultElement = new CompanyUser ();
                        resultElement.initialiseGhost (objectID);
                    }
                    else
                    {
                

                        resultElement = new CompanyUser ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
                    }
                
            }

            results.put (objectID, resultElement);
        }

        
        for (String objectType : needsRefetch.keySet())
        {
            BaseBusinessClass       referenceObject = context.getReferenceObject (CompanyUser.REFERENCE_CompanyUser, objectType);
            ObjectPersistenceMgr    persistenceMgr = context.getPersistenceMgr (referenceObject);
            ResourceCheckpoint      checkpoint = sqlMgr.getCheckpoint();

            Set<BaseBusinessClass>    objsRefetched = persistenceMgr.fetchByIDs(new HashSet (needsRefetch.getValuesForKey (objectType)), allPSets, context, sqlMgr);

            checkpoint.releaseNewResources();

            for (BaseBusinessClass objRefetched : objsRefetched)
            {
                results.put (objRefetched.getID (), (CompanyUser)objRefetched);
            }
        }
        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (CompanyUserPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}oneit_sec_user_extension " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (CompanyUser.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: oneit_sec_user_extension.object_id is not null
                    String preFilter = "(oneit_sec_user_extension.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}oneit_sec_user_extension " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (CompanyUser.SEARCH_AllCompanyUsers))
        {
            // Local scope for transformed variables
            {
                
                if (criteria.containsKey("ReferenceExtension"))
                {
                SecUserExtension ReferenceExtension = (SecUserExtension)(criteria.get("ReferenceExtension"));
                criteria.put ("ReferenceExtension", context.getTag (ReferenceExtension));
                }
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: oneit_sec_user_extension.object_id is not null
                    String preFilter = "(oneit_sec_user_extension.object_id is not null)"
                                     + "  ";
                    
                        if (criteria.containsKey("ReferenceExtension"))
                        {
                            preFilter += " AND (oneit_sec_user_extension.object_type = ${ReferenceExtension}) ";
                            preFilter += "";
                            
                        }
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}oneit_sec_user_extension " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (CompanyUser.SEARCH_IdPin))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: oneit_sec_user_extension.object_id is not null
                    String preFilter = "(oneit_sec_user_extension.object_id is not null)"
                                     + "  ";
                    
                        if (criteria.containsKey("ID"))
                        {
                            preFilter += " AND (object_id = ${ID} ) ";
                            preFilter += "";
                            
                        }
                    
                        if (criteria.containsKey("Pin"))
                        {
                            preFilter += " AND (verification_key = ${Pin}) ";
                            preFilter += "";
                            
                        }
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}oneit_sec_user_extension " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            
                BaseBusinessClass[] resultsArray = super.find(searchType, allPSets, criteria, context, sqlMgr);
                Vector              results = new Vector ();
                
                for (int x = 0 ; x < resultsArray.length ; ++x)
                {
                    if (resultsArray[x] instanceof CompanyUser)
                    {
                        results.add (resultsArray[x]);
                    }
                    else
                    {
                        // Ignore
                    }
                }
                
                resultsArray = new BaseBusinessClass[results.size ()];
                results.copyInto (resultsArray);

                return resultsArray;
            
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension", PersistentSetStatus.FETCHED);
        
            // Object Modified
            oneit_sec_user_extensionPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            oneit_sec_user_extensionPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));oneit_sec_user_extensionPSet.setAttrib("OBJECT_TYPE", r.getString ("OBJECT_TYPE"));

        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_ForgotPasswordMailSendDate, HELPER_ForgotPasswordMailSendDate.getFromRS(dummyForgotPasswordMailSendDate, r, "forgot_password_mail_send_date"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_ForgotPasswordKey, HELPER_ForgotPasswordKey.getFromRS(dummyForgotPasswordKey, r, "forgot_password_key"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_Role, HELPER_Role.getFromRS(dummyRole, r, "role_type"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_Roles, HELPER_Roles.getFromRS(dummyRoles, r, "roles"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_Phone, HELPER_Phone.getFromRS(dummyPhone, r, "phone"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_VerificationMailSendDate, HELPER_VerificationMailSendDate.getFromRS(dummyVerificationMailSendDate, r, "verification_mail_send_date"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_VerificationKey, HELPER_VerificationKey.getFromRS(dummyVerificationKey, r, "verification_key"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_IsAccountVerified, HELPER_IsAccountVerified.getFromRS(dummyIsAccountVerified, r, "is_account_verified"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.FIELD_IsEmailChanged, HELPER_IsEmailChanged.getFromRS(dummyIsEmailChanged, r, "is_email_changed"));
        
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.SINGLEREFERENCE_User, r.getObject ("user_id"));
        oneit_sec_user_extensionPSet.setAttrib(CompanyUser.SINGLEREFERENCE_Company, r.getObject ("company_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension");
        

        
        if (oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}oneit_sec_user_extension " +
                                     "  (forgot_password_mail_send_date, forgot_password_key, role_type, roles, phone, verification_mail_send_date, verification_key, is_account_verified, is_email_changed,  user_id, company_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE, object_TYPE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ", ?)",
                                     CollectionUtils.listEntry (HELPER_ForgotPasswordMailSendDate.getForSQL(dummyForgotPasswordMailSendDate, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_ForgotPasswordMailSendDate))).listEntry (HELPER_ForgotPasswordKey.getForSQL(dummyForgotPasswordKey, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_ForgotPasswordKey))).listEntry (HELPER_Role.getForSQL(dummyRole, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_Role))).listEntry (HELPER_Roles.getForSQL(dummyRoles, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_Roles))).listEntry (HELPER_Phone.getForSQL(dummyPhone, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_Phone))).listEntry (HELPER_VerificationMailSendDate.getForSQL(dummyVerificationMailSendDate, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_VerificationMailSendDate))).listEntry (HELPER_VerificationKey.getForSQL(dummyVerificationKey, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_VerificationKey))).listEntry (HELPER_IsAccountVerified.getForSQL(dummyIsAccountVerified, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_IsAccountVerified))).listEntry (HELPER_IsEmailChanged.getForSQL(dummyIsEmailChanged, oneit_sec_user_extensionPSet.getAttrib (CompanyUser.FIELD_IsEmailChanged))) .listEntry (SQLManager.CheckNull((Long)(oneit_sec_user_extensionPSet.getAttrib (CompanyUser.SINGLEREFERENCE_User)))).listEntry (SQLManager.CheckNull((Long)(oneit_sec_user_extensionPSet.getAttrib (CompanyUser.SINGLEREFERENCE_Company)))) .listEntry (objectID.longID ()).listEntry (context.getTag (obj)).toList().toArray());

            oneit_sec_user_extensionPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
