import { Component, OnInit, ViewChild } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { ApplicantJobModel } from '../../models/applicant-job.model';
import { JobService } from '../../services/job.service';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';
import { ActivatedRoute, Router } from '@angular/router';
import { NgForm } from '@angular/forms';
import { HelperService } from '../../services/helper.service';
import { ToasterService } from '../../services/toaster.service';

@Component({
    selector: 'app-job',
    templateUrl: './job.component.html',
    styleUrls: ['./job.component.scss']
})
export class JobComponent extends BaseComponent implements OnInit {

    applicantJob: ApplicantJobModel = new ApplicantJobModel();
    applicantJobId;

    isLoadingJobLocations = false;
    jobPostLocations = [];

    @ViewChild('form') form: NgForm;

    constructor(
        private activatedRoute: ActivatedRoute,
        private jobService: JobService,
        private utilsService: UtilsService,
        private toastService: ToasterService,
        private helperService: HelperService,
        private router: Router
    ) {
        super();
    }

    ngOnInit() {
        this.activatedRoute.params
            .pipe(takeUntil(this.componentInView))
            .subscribe(params => {
                if (params.id && params.id !== 'new') {
                    this.isEditMode = true;
                    this.applicantJobId = params.id;
                    this.getApplicantJob()
                } else {
                    this.applicantJob = new ApplicantJobModel();
                    this.utilsService.createObject(this.applicantJob, this.createdObjs)
                }
            });

        this.getJobPostLocations();
    }

    getApplicantJob(): void {
        this.isLoading = true;
        this.jobService.getApplicantJob(this.applicantJob)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                console.log(response);
            }, err => {
                this.utilsService.handleError(err);
                this.isLoading = false;
            })
    }

    getJobPostLocations(): void {
        this.isLoadingJobLocations = true;
        this.jobService.getJobPostedLocation()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoadingJobLocations = false;
                this.jobPostLocations = response;
            }, err => {
                this.isLoadingJobLocations = false;
                this.utilsService.handleError(err);
            })
    }

    saveApplicantJob(): void {
        if (this.form.invalid) {
            return this.helperService.validateAllFormFields(this.form);
        }
        this.isLoading = true;
        this.jobService.saveApplicantJob(this.createdObjs, this.updatedObjs, this.deletedObjs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.toastService.success('Job saved');
                console.log(response);
                // this.router.navigate([`my-career-web/intro-letters`])
            }, err => {
                this.utilsService.handleError(err);
                this.isLoading = false;
            });
    }

}
