package performa.orm;

import java.util.Collection;
import oneit.logging.LoggingArea;
import oneit.objstore.StorageException;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.utils.filter.CollectionFilter;
import oneit.utils.filter.Filter;
import oneit.utils.parsers.FieldException;
import performa.orm.types.CriteriaType;


public class JobApplication extends BaseJobApplication
{
    private static final long   serialVersionUID    = 0L;
    public  static LoggingArea  LOG                 = LoggingArea.createLoggingArea("JobApplication");
    
    // This constructor should not be called
    public JobApplication ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    public static JobApplication createNewApplication(Candidate candidate, Job job) throws StorageException, FieldException
    {
        JobApplication  jobApplication  =   createJobApplication(job.getTransaction());
        
        jobApplication.setCandidate(candidate);
        jobApplication.setJob(job);
        
        jobApplication.initACAnswers();
        jobApplication.initCCAnswers();
        
        return jobApplication;
    }
    
    private void initACAnswers()
    {
        for(AssessmentCriteria assessmentCriteria : getJob().getAssessmentCriteriasSet())
        {
            AssessmentCriteriaAnswer    answer  =   AssessmentCriteriaAnswer.createAssessmentCriteriaAnswer(getTransaction());

            addToAssessmentCriteriaAnswers(answer);
            assessmentCriteria.addToAnswers(answer);
        }
    }
    
    private void initCCAnswers()
    {
        for(CultureCriteria cultureCriteria : getJob().getCultureCriteriasSet())
        {
            CultureCriteriaAnswer   answer  = CultureCriteriaAnswer.createCultureCriteriaAnswer(getTransaction());

            addToCultureCriteriaAnswers(answer);
            cultureCriteria.addToAnswers(answer);
        }
    }
    
    
    public Answer getPAAnswerOrCreate(Question question, int index) throws FieldException
    {
        Filter  filter  = Answer.SearchByAll().andQuestion(new EqualsFilter<>(question));
        Answer  answer  = CollectionFilter.getFirstMatch(getProfileAssessmentAnswersSet(), filter);
        
        if(answer==null)
        {
            answer  = Answer.createAnswer(getTransaction());
            
            answer.setJobApplication(this);
            answer.setQuestion(question);
            
            if(question.getRightQuestion()!=null)
            {
                Answer  rightAnswer = Answer.createAnswer(getTransaction());
            
                rightAnswer.setJobApplication(this);
                rightAnswer.setQuestion(question);
            }
        }
        
        return answer;
    }
    
    public Collection<AssessmentCriteriaAnswer> getACAnswersByType(CriteriaType criteriaType)
    {
        Filter  filter  =   AssessmentCriteriaAnswer.SearchByCriteriaType().byCriteriaType(criteriaType);

        return  CollectionFilter.filter(getAssessmentCriteriaAnswersSet(), filter);
    }

    
    public Boolean selectionCompleted()
    {
        return Boolean.FALSE;
    }
       
    
    public Boolean cultureCompleted()
    {
        return Boolean.FALSE;
    }
    
    
    public Boolean assessmentCompleted()
    {
        return Boolean.FALSE;
    }
}