<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    String          hiringTeamList  =   WebUtils.getSamePageInRenderMode(request, "Page");
    String          nextPage        =   WebUtils.getSamePageInRenderMode(request, "ManagePlan");
    SecUser         loggedInUser    =   SecUser.getTXUser(transaction);
    CompanyUser     companyUser     =   loggedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    Company         company         =   companyUser.getCompany();
    HiringTeam      hiringTeam      =   (HiringTeam) process.getAttribute("HiringTeam");

    Debug.assertion(company != null , "Invalid company in admin portal my company");
    
    PaymentPlan[]   plans           =   Utils.getPaymentPlansForJobs(transaction);
    Integer         maxCount        =   0;
    Integer         minCount        =   0;
    
    if(company.getPaymentPlan() != null && company.getPaymentJobCount() == null)
    {
        company.setPaymentJobCount(company.getPaymentPlan().getActiveJobCount());
    }
    
    if(plans.length > 0)
    {
        Collection<Integer> jCounts =   PaymentPlan.pipesPaymentPlan(plans).toActiveJobCount().vals();
        maxCount                    =   Collections.max(jCounts);
        minCount                    =   Collections.min(jCounts);
    }

%>
    <script type="text/javascript">
        $(document).ready(function()
        {
            recalcFunction = setupRecalc ($("form#editCompany"), {'recalcOnError':true});
        });
    </script>
    
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <oneit:form name="editCompany"  method="post"    enctype="multipart/form-data">
                    <oneit:button cssClass="arrow-btn-blue"  name="gotoPage" value=" " skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", hiringTeamList).toMap() %>" >
                        <img src="images/arrow-left-prev_blue.svg" />
                    </oneit:button>
                    <h1 class="page-title"><%= hiringTeam.getHiringTeamName() %></h1>
                    <div class="my-company-area">
                        
                        <div style="padding-left: 15px; padding-right: 15px;">
                            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        </div>

                        <oneit:dynInclude   page="/extensions/adminportal/inc/my_company_tabs.jsp"    TabNumber="2"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                        <div class="company-content-area">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="tab-pane active" id="company-detail">
                                    <div class="tabpage-title">
                                        <label class="label-20">Manage Plan</label>                
                                    </div>
                                    <div>
                                        <oneit:ormInput obj="<%= hiringTeam %>"    type="text" attributeName="CouponCode"    cssClass="form-control" />      
                                        <oneit:button   value="Apply"     name="saveCompany"      cssClass="btn btn-primary"
                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                        .toMap() %>" />
                                    </div>
                                    <div>
                                        coupon applied 
                                        <oneit:toString value="ABCD123" mode="EscapeHTML"/> - save
                                        <oneit:toString value="10%" mode="EscapeHTML"/>
                                        Expires
                                        <oneit:toString value="18 Sep 2018" mode="EscapeHTML"/>
                                    </div>


                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <div class="oneit-radio">
                                                <label class="create-job-selector rectangle-4">
                                                    <oneit:ormInput obj="<%= hiringTeam %>" type="radio" attributeName="IsPPJ" value="true"/>
                                                    <div>
                                                        Pay Per Job 
                                                        <br/>
                                                        <span>
                                                            You'll be charged each time you add a new job
                                                        </span>
                                                        <br/>
                                                        <oneit:toString value="<%= PaymentPlan.PER_PER_JOB_AMOUNT %>" mode="Currency"/>/ Job
                                                        <br/>
                                                        was <oneit:toString value="<%= PaymentPlan.PER_PER_JOB_AMOUNT %>" mode="Currency"/> per job
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-12"> 
                                            <div class="oneit-radio" >
                                                <label class="create-job-selector rectangle-4">
                                                    <oneit:ormInput obj="<%= hiringTeam %>" type="radio" attributeName="IsPPJ" value="false"/>
                                                    <div>
                                                        Subscribe & Save
                                                        <br/>
                                                        <span>
                                                            Intend to post multiple jobs this month?
                                                            Find a plan to suit your hiring needs, and save today.
                                                        </spa<n>
                                                    </div>
                                                </label>
                                                <div>
                                                    Your subscription is billed and resets on the   <oneit:toString value="12th" mode="EscapeHTML"/> of every month
                                                </div>
                                                <div>
                                                    Choose Your Plan
                                                </div>
                                                <div>
                                                    <br/>
                                                    10 Jobs 
                                                    <br/><br/>
                                                    <oneit:toString value="<%= 243.00 %>" mode="Currency"/>
                                                    <br/>
                                                    was <oneit:toString value="<%= 270.00 %>" mode="Currency"/>
                                                    <br/><br/>
                                                    <oneit:toString value="<%= 2430.00 %>" mode="Currency"/> / month
                                                    <br/>
                                                    was <oneit:toString value="<%= 2700.00 %>" mode="Currency"/>
                                                </div>


                                                <oneit:button   value="Active"     name="saveCompany"      cssClass="btn btn-primary"
                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                        .toMap() %>" />

                                                <oneit:button   value="Select"     name="saveCompany"      cssClass="btn btn-primary"
                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                        .toMap() %>" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <span>
                                                Additional jobs over plan allowance are billed at the Cost Per Job for the subscription level
                                            </span>
                                            <span>
                                                Would you like to set a maximum limit on the total jobs able to be posted
                                            </span>
                                        </div>
                                    </div>        
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <span>
                                                Would you like to set a maximum limit on the total jobs able to be posted
                                            </span>
                                        </div>
                                    </div>        

                                    <div class="form-group row">
                                        No, leave it open
                                        <label class="switch">
                                            <oneit:recalcClass  htmlTag="span"  classScript="hiringTeam.isTrue(hiringTeam.getHasCap()) ? 'checkbox checked': 'checkbox unchecked'"    hiringTeam="<%= hiringTeam %>">
                                                <oneit:ormInput obj="<%= hiringTeam %>"    attributeName="HasCap"   type="checkbox"/>
                                            </oneit:recalcClass>
                                            <div class="slider round"></div>
                                        </label>
                                        yes, set a cap
                                    </div>
                                    <div class="form-group row">
                                        <oneit:ormInput obj="<%= hiringTeam %>"    type="text" attributeName="MaxCap"    cssClass="form-control" />      

                                        <oneit:button   value="Set Max"     name="saveCompany"      cssClass="btn btn-primary"
                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                        .toMap() %>" />
                                    </div>

                                    <div class="form-group row">
                                        <oneit:button   value="Update Subscription" name="saveCompany"      cssClass="btn btn-primary largeBtn btn-green save-btn" style="display:none;"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                        .mapEntry ("Company", company)
                                                                                        .mapEntry ("IsPayment", Boolean.TRUE)
                                                                                        .mapEntry ("attribNamesToRestore", Collections.singleton("Company"))
                                                                                        .toMap() %>" />
                                    </div>

                                    <div class="text-center footer-note">
                                        Looking to cancel your account? Please <a href="http://www.talentology.com/">contact us.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </oneit:form>
            </div>
        </div>
    </div>
</oneit:dynIncluded>
