<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    SecUser     loggedInUser    =   SecUser.getTXUser(transaction);
    CompanyUser companyUser     =   loggedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    HiringTeam  hiringTeam      =   companyUser.getActiveHiringTeam();
    Company     company         =   hiringTeam.getCompany();
    String      nextPage        =   WebUtils.getArticleByShortCut(transaction, WebUtils.ADMIN_HOME).getLink(request);

    Debug.assertion(company != null , "Invalid company in admin portal my company");
    
    boolean     readOnly        =   company.getObjectWriteability() == FieldWriteability.NOT_IN_GUI;

%>
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <oneit:form name="editCompany"  method="post"    enctype="multipart/form-data">
                    
                    <h1 class="page-title">Manage Customer</h1>
                    
                    <div class="my-company-area manage-company">
                        <div style="padding-left: 15px; padding-right: 15px;">
                            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        </div>
                        
                        <div class="company-content-area manage-company">
                            <!-- Tab panes -->
                            <div class="tab-content form-content-wrap">
                                <div class="tab-pane active" id="company-detail">
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label><oneit:label GUIName="Customer Name"/></label>
                                            <oneit:ormInput obj="<%= company %>"    type="text" attributeName="CompanyName" cssClass="form-control"/>                                
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label><oneit:label GUIName="What type of hiring team are you?" /></label>
                                            <%
                                                FormTag     jobForm     =   FormTag.getActiveFormTag(request);
                                                FormBuilder formBuilder =   jobForm.getFormBuilder();
                                                String      optionKey   =   WebUtils.getInputKey(request, company, Company.FIELD_HiringTeamType);
                                                String      formValue   =   formBuilder.fieldValue (optionKey, company.getHiringTeamType() == null ? "" : company.getHiringTeamType().getName());

                                                for(HiringTeamType hiringTeamType : HiringTeamType.getHiringTeamTypeArray())
                                                {
                                                    boolean isSelected          =   CollectionUtils.equals(formValue, hiringTeamType.getName());
                                                    String  hiringTeamTypeId    =   String.valueOf(company.getID().longID()) + "_hiringteamtype_" + hiringTeamType.getName();
                                                    String  selected            =   isSelected ? "checked" : "";
                                                    String  activeClass         =   isSelected ? "active" : "";
                                                    String  disabled            =   isSelected ? "" : readOnly? "disabled" : "";
                                            %>
                                                    <div    class="radio radio-primary workplace-radio manage-company">
                                                        <input  type="radio"    name="<%= optionKey %>"    id="<%= hiringTeamTypeId %>"    class="element_rating_radio" value="<%= hiringTeamType.getName() %>" <%= selected %> <%= disabled %>>
                                                        <label  for="<%= hiringTeamTypeId %>">
                                                            <oneit:toString value="<%= hiringTeamType %>"   mode="EscapeHTML"/>
                                                        </label>
                                                    </div>
                                            <%
                                                }
                                            %>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-8">
                                            <label><oneit:label GUIName="Time Zone" /></label>
                                            <oneit:ormEnum  obj="<%= company %>"    attributeName="TimeZone" cssClass="form-control"/>
                                        </div>
                                    </div>
                                </div> 
                                        
                                    <div class="text-center form-group">
                                        <oneit:button   value="Cancel" name="gotoPage" cssClass="btn btn-primary largeBtn greyBtn"
                                                        requestAttribs='<%= CollectionUtils.mapEntry ("nextPage", nextPage)
                                                                                            .mapEntry("cancelProcess", true)
                                                                                            .toMap() %>'/>
                                        <oneit:button   value="Save"    name="save"  cssClass="btn btn-primary largeBtn"    disabled="<%= readOnly ? "true" : "false" %>"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                            .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                            .mapEntry("Company", company)
                                                                                            .toMap() %>" />
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </oneit:form>
            </div>
        </div>
</oneit:dynIncluded>
