<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
 
<%@ page import="oneit.utils.filter.*"%>

<oneit:dynIncluded>
<%
    String                  nextPage        =   WebUtils.getSamePageInRenderMode(request, WebUtils.EDIT_JOB_TEMP);
    String                  homePage        =   WebUtils.getSamePageInRenderMode(request, "Page");
    SecUser                 secUser         =   SecUser.getTXUser(transaction);
    CompanyUser             companyUser     =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    HiringTeam              hiringTeam      =   companyUser.getSelectedTeam();
    Map<String, String[]>   parameterMap    =   request.getParameterMap();
    Client                  selectedClient  =   null;

    if(!hiringTeam.hasBillingSetup())
    {
        response.sendRedirect(WebUtils.getArticleByShortCut(transaction, WebUtils.ADMIN_HOME).getLink(request));
    }

    AssessmentCriteriaTemplate[]   templates   =   (AssessmentCriteriaTemplate[]) process.getAttribute("AssessmentCriteriaTemplates");

    if(templates == null)
    {
        templates   =   AssessmentCriteriaTemplate.SearchByAll()
                                                    .andHiringTeam(new EqualsFilter<>(hiringTeam))
                                                    .andCompanyUser(new EqualsFilter<>(companyUser))
                                                    .search(transaction);
        
        process.setAttribute("AssessmentCriteriaTemplates", templates);
    }
     
    // handle client
    if( parameterMap.containsKey("Client"))
    {
        if(!request.getParameter("Client").isEmpty())
        {
            selectedClient  =   Client.getClientByID(transaction, Long.valueOf(request.getParameter("Client")));
        }
    }

    List<AssessmentCriteriaTemplate>    templateList =   Arrays.asList(templates);

    // filter templates by client
    if(selectedClient != null && selectedClient.getInTransaction(transaction).getHiringTeam() == hiringTeam)
    {
        oneit.utils.filter.Filter<AssessmentCriteriaTemplate>  filter  =   AssessmentCriteriaTemplate.SearchByAll().andClient(new EqualsFilter<>(selectedClient));

        templateList =   new ArrayList<>(CollectionFilter.filter(templateList, filter));
    }
%>
    <oneit:form name="jobTemplates" method="post"    enctype="multipart/form-data">

        <div class="dashboard-content-area second-part">
                        
            <div class="jobs-list-shorting">
                <div class="d-job-title all-jobs-title">Manage Job Templates</div>
                <%
                    if(hiringTeam.showHasClientSupport())
                    {
                %>
                        <div class="shorting-dropdown">
                            <div class="order-label">client</div>
                            <select class="form-control"    onChange="location=this.value">
                                <option <%= (selectedClient == null ? "selected" : "" )%>  value="<%= homePage + "&Client"%>">
                                    <oneit:toString value="All Clients"   mode="EscapeHTML"/>
                                </option>
                                <%
                                    for (Client  client : Utils.getClientsByHiringTeam(transaction))
                                    {
                                        String  optionLink  =    homePage + "&Client=" + client.getID().longID() ;
                                %>
                                        <option <%= (client != null && selectedClient != null && client.equals(selectedClient) ? "selected" : "" )%>  value="<%= optionLink %>">
                                            <oneit:toString value="<%= client.getClientName() %>"   mode="EscapeHTML"/>
                                        </option>
                                <%
                                    }
                                %>
                            </select>
                        </div>
                <%
                    }
                %>
            </div>
            
                    
            <div class="main-client-list">
            <%
                for(AssessmentCriteriaTemplate template : templateList)
                {
            %>
                    <div class="template-list"   id="<%= template.getID() %>">
                        <div class="template-row">
                            <div class="job-template-left job-template-cl1">
                                <div class="template-name heading">
                                    <oneit:toString value="<%= template.getTemplateName() %>" mode="EscapeHTML" />
                                </div>
                            </div>
                            <div class="job-template-left job-template-cl2">
                                <span class="grey-span">JOB TITLE</span>
                                <div class="template-name">
                                    <oneit:toString value="<%= template.getJobTitle() %>" mode="EscapeHTML" />
                                </div>
                            </div>
                            <div class="job-template-left job-template-cl3">
                                <span class="grey-span">CLIENT</span>
                                <div class="template-name">
                                    <oneit:toString value="<%= template.getClient() %>" mode="EscapeHTML" />
                                </div>
                            </div>
                            <div class="job-template-left job-template-cl4">
                                <span class="grey-span">LAST UPDATED</span>
                                <div class="template-name">
                                    <oneit:toString value="<%= template.getObjectLastModified() %>" mode="MidDate" />
                                </div>
                                <div class="m-user-right-padlock">
                                    <oneit:button   value=" "    name="gotoPage"    skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage + "&AssessmentCriteriaTemplateID=" + template.getObjectID())
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("AssessmentCriteriaTemplate", template).toMap())
                                                                                .toMap() %>">
                                        <span class="m-user-right-padlockicon">
                                            <span class="pencil"></span>
                                        </span>
                                    </oneit:button>
                                </div>
                            </div>
                        </div>
                    </div>
            <%
                }
            %>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>