import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';
import { AppService } from '../../app.service';
import { SEARCH, SERVICES } from '../../constants';
import { MessageTemplateModel } from '../../models/messageTemplate.model';
import { SorterModel } from '../../models/sorterModel';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { BaseComponent } from '../base/base.component';

@Component({
    selector: 'app-list-message-template',
    templateUrl: './list-message-template.component.html',
    styleUrls: ['./list-message-template.component.scss']
})
export class ListMessageTemplateComponent extends BaseComponent implements OnInit {

    subscriptions: Array<Subscription> = [];
    myTemplates: Array<MessageTemplateModel> = [];
    sharedTemplates: Array<MessageTemplateModel> = [];
    sortOptions: Array<SorterModel>;
    sortSelected: SorterModel;
    allowSort: boolean;
    showLoader = false;

    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private searchService: SearchService,
        private appService: AppService
    ) {
        super(utilsService);
    }

    ngOnInit(): void {
        this.sortOptions = [
            new SorterModel('Alphabetical (A-Z)', true),
            new SorterModel('Alphabetical (Z-A)', false)
        ];
        // this.sortSelected = new SorterModel('Alphabetical (A-Z)', true);
        this.showLoader = true;
        const sharedMsgParams = {
            OnlyGlobalTemplate: true
        };
        const myMsgParams = {
            OnlyGlobalTemplate: false
        };
        this.subscriptions.push(
            this.appService.getSearchListing(SERVICES.MESSAGE_TEMPLATES, 'All', myMsgParams, [], SEARCH.MESSAGE_TEMPLATE)
                .subscribe(
                    messages => {
                        this.myTemplates = messages;
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
        )
        ;
        this.subscriptions.push(
            this.appService
                .getSearchListing(SERVICES.MESSAGE_TEMPLATES, 'All', sharedMsgParams, [], SEARCH.MESSAGE_TEMPLATE)
                .subscribe(
                    messages => {
                        this.sharedTemplates = messages;
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
        );
        setTimeout(() => (this.showLoader = false), 0);
    }

    sortMessageTemplates(): void {

        if (this.allowSort) {
            this.showLoader = true;
            this.myTemplates = this.utilsService.sort(this.myTemplates,
                ['TemplateName'], [this.sortSelected.ascending ? 1 : -1], false);
            this.sharedTemplates = this.utilsService.sort(this.sharedTemplates,
                ['TemplateName'], [this.sortSelected.ascending ? 1 : -1], false);
            this.allowSort = false;
            this.showLoader = false;
        }

    }

    setDefaultSorter(): void {

        if (!this.sortSelected) {
            this.sortSelected = new SorterModel('Alphabetical (A-Z)', true);
        }

        this.allowSort = true;
    }

    onRowSelect(data: MessageTemplateModel): void {
        this.showLoader = true;
        this.router.navigate(['/edit-message-template', data.ObjectID]);
    }
}
