import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { EditMessageTemplateComponent } from './components/edit-message-template/edit-message-template.component';
import { EditWorkflowTemplateComponent } from "./components/edit-workflow-template/edit-workflow-template.component";
import { ListMessageTemplateComponent } from './components/list-message-template/list-message-template.component';
import { ListWorkFlowsComponent } from './components/list-work-flows/list-work-flows.component';

import { AccessDeniedComponent } from './oneit/components/access-denied/access-denied.component';
import { FullLayoutComponent } from './oneit/components/full-layout/full-layout.component';
import { HomeComponent } from './oneit/components/home/home.component';
import { IframePageComponent } from './oneit/components/iframe-page/iframe-page.component';

import { AuthGuard } from './oneit/guards/auth.guard';

export const routes: Routes = [
    {
        path: '',
        redirectTo: 'home',
        pathMatch: 'full'
    },
    {
        path: '',
        component: FullLayoutComponent,
        data: {
            showDefaultHeader: true,
            showDefaultFooter: true,
            showMenu: true,
            showFeedback: true
        },
        children: [
            {
                path: 'access-denied',
                component: AccessDeniedComponent
            },
            {
                path: 'home',
                canActivate: [AuthGuard],
                component: HomeComponent
            },
            {
                path: 'iframe-page/:url',
                canActivate: [AuthGuard],
                component: IframePageComponent,
                runGuardsAndResolvers: 'always'
            },
            {
                path: 'edit-message-template',
                component: EditMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-message-template/:id',
                component: EditMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'list-message-template',
                component: ListMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'list-work-flows',
                component: ListWorkFlowsComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-workflow-template',
                component: EditWorkflowTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-workflow-template/:id',
                component: EditWorkflowTemplateComponent,
                canActivate: [AuthGuard]
            }
        ]
    }
    // Don't forget to add below line in app.module.ts
    // entryComponents: [CustomHeaderComponent],
];

@NgModule({
    imports: [RouterModule.forRoot(routes, {useHash: true, onSameUrlNavigation: 'reload'})],
    exports: [RouterModule]
})
export class AppRoutingModule {
}
