import { NgModule } from '@angular/core';
import { FormBuilder } from '@angular/forms';

import { ConfirmationService, EditorModule, InputSwitchModule, OverlayPanelModule, PanelModule } from 'primeng/primeng';

import { AppComponent } from './app.component';
import { AppRoutingModule } from './app.routing';
import { AppService } from './app.service';
import { EditMessageTemplateComponent } from './components/edit-message-template/edit-message-template.component';
import { EditMessageTemplateService } from './components/edit-message-template/edit-message-template.service';
import { EditWorkflowTemplateComponent } from './components/edit-workflow-template/edit-workflow-template.component';
import { EditWorkflowTemplateService } from './components/edit-workflow-template/edit-workflow-template.service';
import { ListMessageTemplateComponent } from './components/list-message-template/list-message-template.component';
import { ListWorkFlowsComponent } from './components/list-work-flows/list-work-flows.component';

import { FullLayoutComponent } from './oneit/components/full-layout/full-layout.component';
import { OneITModule } from './oneit/oneit.module';

@NgModule({
    imports: [
        AppRoutingModule,
        OneITModule,
        EditorModule,
        OverlayPanelModule,
        PanelModule,
        InputSwitchModule
    ],
    declarations: [
        AppComponent,
        FullLayoutComponent,
        EditMessageTemplateComponent,
        EditWorkflowTemplateComponent,
        ListMessageTemplateComponent,
        ListWorkFlowsComponent
    ],
    providers: [
        FormBuilder,
        ConfirmationService,
        AppService,
        EditMessageTemplateService,
        EditWorkflowTemplateService
    ],
    bootstrap: [AppComponent]
})

export class AppModule {
    // tslint:disable-next-line:no-empty
    constructor() {
    }
}
