package performa.utils;

import au.com.m4u.smsapi.*;
import java.io.IOException;
import java.util.Set;
import oneit.appservices.config.ConfigMgr;
import oneit.components.*;
import oneit.logging.*;
import oneit.utils.*;

/**
 *
 * @author chamathkalhara
 */
public class SMSUtils implements InitialisationParticipant
{
    public  static  final   LoggingArea     LOG                     = LoggingArea.createLoggingArea("SMSUtilsLog");
    private static  final   String          SIMULATE_EXEMPTIONS     = ConfigMgr.getKeyfileString ("sms.simulate.exemptions", null);
    private static  final   Set<String>     SIMULATE_EXEMPTION_SET  = CollectionUtils.createSet(StringUtils.split(SIMULATE_EXEMPTIONS, ';'));
    
    private String  userName;
    private String  password;
    private boolean doNotSend       = true;
    private int     messageFormat   = 2;
    
    
    public boolean isSendingForReal ()
    {
        return ! doNotSend;
    }
    
    
    private SmsInterface openConnection (boolean secureMode, boolean debug) throws IOException
    {
        SmsInterface    si          = new SmsInterface(messageFormat);

        si.useSecureMode(secureMode);
        si.setDebug(debug);

        LogMgr.log(LOG, LogLevel.DEBUG2, "Connecting to SMS SmsInterface with ", userName);

        if (! si.connect (userName, password, false))
        {
            LogMgr.log(LOG, LogLevel.DEBUG2, "Failed in Connecting to SMS Interface");
            throw new IOException("SMS: Cannot connect");
        }
        else
        {
            LogMgr.log(LOG, LogLevel.DEBUG2, "Connected to SMS SmsInterface");
        }

        return si;
    }
    
    
    public void sendSMS (String message, String number, Short validityPeriod) throws IOException
    {
        sendSMS(message, number, validityPeriod, LOG);
    }
    
    
    public void sendSMS (String message, String number, Short validityPeriod, LoggingArea log) throws IOException
    {
        if (doNotSend && (SIMULATE_EXEMPTION_SET == null || !SIMULATE_EXEMPTION_SET.contains(number)))
        {
            LogMgr.log(log, LogLevel.BUSINESS1, "PRETEND Sending SMS [", message, "] ", number);
        }
        else
        {
            SmsInterface    sms =   openConnection(true, true);

            sms.addMessage(number, message, 0, 0, validityPeriod == null ? ValidityPeriod.DEFAULT : validityPeriod.shortValue(), false);
            LogMgr.log(log, LogLevel.BUSINESS1, "Sending SMS ", number);

            if (sms.sendMessages ())
            {
                LogMgr.log(log, LogLevel.PROCESSING2, "SMS Sent [", message, "] response code ", sms.getResponseCode());
            }
            else
            {
                LogMgr.log(log, LogLevel.BUSINESS2, "SMS Failed [", message, "] response code ", sms.getResponseCode(), " ResponseMessage:", sms.getResponseMessage());
                throw new IOException("SMS Failed [" + message + "] response code " + sms.getResponseCode());
            }
        }
    }
    
    
    @Override
    public void init(ParticipantInitialisationContext context) throws InitialisationException
    {
        userName    = context.getSingleChild("userName", userName).toString();
        password    = context.getSingleChild("password", password).toString();
        doNotSend   = (Boolean)context.getSingleChild("simulate", Boolean.TRUE);
    }
}
