<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils"%>

<%
    Job                 job             =   (Job) process.getAttribute("Job");
    AppSortOption       appSortOpt      =   (AppSortOption) getData(request, "sortOption");
    ApplicationStatus   appStatus       =   (ApplicationStatus)  getData(request, "appStatus"); 
    ApplicationStatus   workflowStatus  =   (ApplicationStatus)  getData(request, "workflowStatus"); 
    Boolean             showOrderBy     =   getData(request, "showOrderBy")!= null ? (Boolean)  getData(request, "showOrderBy") : Boolean.FALSE;
    boolean             showList        =   (boolean)  getData(request, "ShowList");
    SearchApplicant     searchApplicant =   (SearchApplicant)  getData(request, "SearchApplicant");
    String              applicantsPage  =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS) + "&JobID=" + job.getID();
%>

<oneit:dynIncluded>
    <script type="text/javascript">
        $(document).ready(function() 
        {            
            $(".bullk-app-process").change(function()
            {
                $('.bulk-update').click();
            });
            
            enableBulkEdit();
             
            $(".applicant").change(function() {
                enableBulkEdit();
            });
            
            $('#AppProcessOption option:selected').removeAttr('selected');
            $('#AppProcessOption option:nth-child(1)').attr('selected','selected');
            $('#select2-AppProcessOption-container').empty();
            $('#select2-AppProcessOption-container').data("title", $('#select2-AppProcessOption-container').attr("title")).removeAttr("title");
        });
        
        function enableBulkEdit() {
            $(".bullk-app-process").prop("disabled",$('input[class=applicant]:checked').length===0);
        }
        
        $('#searchText').keypress(function (e) {
            if (e.which === 13) {
              $('input[name = Search]').click();
              return false;  
            }
        });
    </script>
    <div class="main-applicants-filter">
        <div class="appli-list-shorting">
            <div class="appli-shorting-dropdown appli-left">
                <span class="appli-order-label">Bulk Update</span>
                <oneit:ormEnum  obj="<%= job %>"    attributeName="AppProcessOption"    cssClass="form-control bullk-app-process"   id="AppProcessOption"
                                enums="<%= job.getValidProcessOptions(appStatus) %>"/>
                
                <oneit:button   name="bulkupdate"   value=" "   cssClass="bulk-update"  skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                    .mapEntry ("attribNamesToRestore", Collections.singleton("Job"))
                                                                    .mapEntry("Job", job)
                                                                    .toMap() %>" />
            </div> 
            
            <div class="appli-filter">
                <ul class="">
                    <li class="lable-appli-shorting">View</li>
                    <li class="<%= (showList ? "active" : "" ) + " short-list"%>">
                            <oneit:button   value="List"   name="gotoPage" skin="link"
                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("ShowList", true).toMap())
                                                            .toMap() %>"/>
                    </li>
                    <li class="<%= (!showList ? "active" : "" ) + " grid-list"%>">
                            <oneit:button   value="Grid"   name="gotoPage" skin="link"
                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("ShowList", false).toMap())
                                                            .toMap() %>"/>
                    </li>
                </ul>
            </div>
            <div class="shorting-dropdown">
                <div class="appli-order-label">Search Applicants</div>
                <oneit:ormInput obj="<%= searchApplicant %>"    type="text" attributeName="Details"    cssClass="form-control search-input"    id="searchText" />
            </div>
            <oneit:button value="Search" name="search" cssClass="btn btn-primary"   style="display:none;"/>
            <%
                if(showOrderBy)
                {
            %>
                    <div class="shorting-dropdown">
                        <span class="appli-order-label">order by</span>
                        <select class="form-control"    onChange="location=this.value">
                        <%
                            for (AppSortOption  sortOption : AppSortOption.getAppSortOptionArray())
                            {
                                String  optionLink  =   applicantsPage + "&AppSortOption=" + sortOption.getName();
                        %>
                                <option <%= (appSortOpt != null && appSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                    <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                </option>
                        <%
                            }
                        %>
                        </select>
                    </div>
            <%
                }
            %>
            <%
                if(workflowStatus == ApplicationStatus.SUBMITTED)
                {
            %>
                    <div class="shorting-dropdown">
                        <span class="appli-order-label">Showing</span>
                        <select class="form-control"    onChange="location=this.value">
                            <option <%= (appStatus == null ? "selected" : "" )%>  value="<%= applicantsPage + "&ApplicationStatus" %>">
                                <oneit:toString value="All Applicants"   mode="EscapeHTML"/>
                            </option>
                        <%
                            for (WorkFlow workflow : job.getSortedWorkFlows())
                            {
                                ApplicationStatus   status      =   workflow.getApplicationStatus();
                                String              optionLink  =   applicantsPage + "&ApplicationStatus=" + status.getName();
                        %>
                                <option <%= (appStatus != null && appStatus == status ? "selected" : "" )%>  value="<%= optionLink %>">
                                    <oneit:toString value="<%= workflow.getName() %>"   mode="EscapeHTML"/>
                                </option>
                        <%
                            }
                        %>
                        </select>
                    </div>
            <%
                }
            %>
        </div>
    </div>
        
</oneit:dynIncluded>
