package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.servlets.forms.NavigationFP;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.utils.BusinessException;
import oneit.utils.MultiException;
import performa.orm.Job;
import performa.utils.Utils;


public class NavigateToCreateJobFP extends NavigationFP
{
    @Override
    public SuccessfulResult processForm(SubmissionDetails submission) throws BusinessException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   (Job) request.getAttribute ("Job");
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1,"In NavigateToCreateJobFP navigating to create job with from template : ", job.getFromTemplate());

        if(job.isTrue(job.getFromTemplate()))
        {
        }
        
        if(job.isTrue(job.getFromTemplate()))
        {
            if(job.getJobTemplate() == null)
            {
                throw new BusinessException("Please select a template before starting the job");
            }
            
            LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside NavigateToCreateJobFP for ", job, " load from template:", job.getJobTemplate());

            Utils.setupJobFromTemplate(job, job.getJobTemplate());

            LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "NavigateToCreateJobFP completed for ", job);
        }
        
        return super.processForm(submission);
    }

    @Override
    protected Map validate(SubmissionDetails submission, MultiException exceptions) 
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   (Job) request.getAttribute ("Job");
        
        if(job != null && job.isTrue(job.getFromTemplate()))
        {
            BusinessObjectParser.assertFieldCondition(job.getJobTemplate() != null , job, Job.SINGLEREFERENCE_JobTemplate, "mandatory", exceptions, true, request);
        }
        
        return super.validate(submission, exceptions);
    }
}
