<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<%
    Job     job         = (Job) process.getAttribute("Job");

    Debug.assertion(job != null, "Job is null in admin portal view applicants");
    
    String  editJobPage     = WebUtils.getSamePageInRenderMode(request, WebUtils.EDIT_JOB);
    String  applicationPage = WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    int     closingInDays   = DateDiff.getDateDiff(Calendar.DATE, DateDiff.getToday(), job.getApplyBy());
%>

    <script type="text/javascript">
        function gotoEditApplication (id) {
            $('.' + id).click();
        }
    </script>
    
    <oneit:form name="viewApplicants" method="post"    enctype="multipart/form-data">
        
        <oneit:dynInclude   page="/extensions/adminportal/inc/applicant_view_tabs.jsp"  TabNumber="1"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="dashboard-content-area second-part view-app-area">
            <div class="five-boxs">
                <%
                    int index   = 0;

                    for(JobApplication jobApplication : job.getJobApplicationsSet())
                    {
                %>
                        <div class="appl-c-box application-row" onClick='gotoEditApplication("<%= jobApplication.getID() %>")'>
                            <oneit:button   value="EDIT"    name="gotoPage" cssClass="<%= jobApplication.getID() + " hidden"%>" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                            .toMap() %>"/>
                            <!--TODO: need to work on the logic. just added to demonstrate that there are 3 different colors for this-->
                            <div class="<%= "cb-title " + (index == 0 ? "green-back" : (index < 3 ? "blue-back" : "dark-back" ))%> ">
                                <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                                
                            </div>
                            <div class="overall-suitablity">
                                <div class="<%= "over-all " + (index == 0 ? "f-60 green" : (index < 3 ? "blue"  : "gray"))%> ">
                                    <oneit:toString value="<%= jobApplication.getOverallSuitability() %>"   mode="PercentageWholeNumber" />
                                </div>
                                <div class="overall">overall suitablity</div>
                            </div>
                            <div class="jcc-box">
                                <div class="job-match jcc">
                                    <img src="images/app-job-match-icon.png"> job match 
                                    <span>
                                        <oneit:toString value="<%= jobApplication.getJobMatchPercentage() %>"   mode="PercentageWholeNumber" />
                                    </span>
                                </div>
                                <div class="culture jcc">
                                    <img src="images/culture-icon.png"> culture
                                    <span>
                                        <oneit:toString value="<%= jobApplication.getCulturePercentage() %>"    mode="PercentageWholeNumber" />
                                    </span>
                                </div>
                                <div class="criteria jcc">
                                    <img src="images/criteria-icon.png"> criteria
                                    <span>
                                        <oneit:toString value="<%= jobApplication.getCriteriaPercentage() %>"   mode="PercentageWholeNumber" />
                                    </span>
                                </div>
                            </div>
                        </div>
                <%
                        index++;
                    }
                %>
                <div class="app-border-bottom"></div>    
            </div>            
            <div class="main-expand-btn">
                <div class="expand-btn">Expand shortlist <img src="images/arrow-white-icon.png"></div>
            </div>
            <div class="app-line-br">
                <span></span>
            </div>
            <div class="main-applicants-filter">
                <div class="appli-list-shorting">
                    <div class="appli-shorting-dropdown appli-left">
                        <span class="appli-order-label">Bulk edit</span>
                        <select class="form-control">
                            <option>Interview</option>
                        </select>
                    </div>
                    <div class="appli-filter">
                        <ul class="">
                            <li class="lable-appli-shorting">showing</li>
                            <li class="active">
                                <a href="#">
                                    ALL Applicants (<oneit:toString value="<%= job.getJobApplicationsCount() %>"    mode="Integer" />)
                                </a>
                            </li>
                            <li><a href="#">Qualified</a></li>
                        </ul>
                    </div>          
                    <div class="appli-shorting-dropdown">
                        <span class="appli-order-label">Export</span>
                        <select class="form-control">
                            <option>PDF</option>
                            <option>CSV</option>
                            <option>XML</option>
                        </select>
                    </div>
                    <div class="appli-shorting-dropdown">
                        <span class="appli-order-label">order by</span>
                        <select class="form-control">
                            <option>Suitability</option>
                            <option>Newest</option>
                            <option>Oldest</option>              
                        </select>
                    </div>
                </div>
            </div>
            <div class="view-appli-list">
            <%
                int j   = 0;

                for(JobApplication jobApplication : job.getJobApplicationsSet())
                {
                    String  jobMatch    =   FormatUtils.stringify(jobApplication.getJobMatchPercentage(), "PercentageWholeNumber", "0");
                    String  culture     =   FormatUtils.stringify(jobApplication.getCulturePercentage(), "PercentageWholeNumber", "0");
                    String  criteria    =   FormatUtils.stringify(jobApplication.getCriteriaPercentage(), "PercentageWholeNumber", "0");
            %>
                    <div class="appli-row">
                        <div class="appli-checkbox appli-l eq-second-height">
                            <div class="checkbox-list">
                                <input id="checkbox1" type="checkbox">
                                <label for="checkbox1"></label>
                            </div>
                        </div>
                        <div class="appli-list-name appli-l eq-second-height">
                            <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                            <div class="appli-int-status">Interview 1 - schedulded</div>
                        </div>
                        <div class="appli-jcs appli-l eq-second-height">
                            <span class="appli-view-bar">
                                <div class="progress">
                                    <div class="progress-bar" role="progressbar" aria-valuenow="<%= jobMatch %>" aria-valuemin="0" aria-valuemax="100" 
                                            style="<%= "width: " + jobMatch %>">
                                    </div>
                                </div>
                            </span>
                            Job Match
                        </div>
                        <div class="appli-jcs appli-l eq-second-height">
                            <span class="appli-view-bar">
                                <div class="progress">
                                    <div class="progress-bar" role="progressbar" aria-valuenow="<%= culture %>" aria-valuemin="0" aria-valuemax="100" 
                                            style="<%= "width: " + culture %>">
                                    </div>                                
                                </div>
                            </span>
                            culture
                        </div>
                        <div class="appli-jcs appli-l eq-second-height">
                            <span class="appli-view-bar">
                                <div class="progress">
                                    <div class="progress-bar" role="progressbar" aria-valuenow="<%= criteria %>" aria-valuemin="0" aria-valuemax="100" 
                                            style="<%= "width: " + criteria %>">
                                    </div>
                                </div>
                            </span>
                            selection criteria
                        </div>
                        <div class="appli-status appli-l eq-second-height">
                            <!--TODO: logic needed to be worked out. Added to note that there are three colors-->
                            <div class="<%= "appli-percent-no " + (j == 0 ? "green" : (j < 3 ? "blue" : "grey" ))%>">
                                <oneit:toString value="<%= jobApplication.getOverallSuitability() %>"   mode="PercentageWholeNumber" />
                            </div>
                            <div class="appli-list-drop">
                                <select class="form-control">
                                    <option>Interview</option>
                                </select>
                            </div>
                        </div> 
                    </div>
            <%
                    j++;
                }
            %>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>