
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class CandidatePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea CandidatePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Candidate");

    // Private attributes corresponding to business object data
    private String dummyFirstName;
    private String dummyMiddleName;
    private String dummyLastName;
    private String dummyPreferredName;
    private String dummySalutation;
    private String dummyPosition;
    private Date dummyDateOfBirth;
    private Date dummyDateRegistered;
    private String dummyGender;
    private String dummyPassword;
    private Date dummyDateTaken;
    private String dummyLocation;
    private String dummyPhone;
    private String dummyEmail;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_FirstName = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_MiddleName = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LastName = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_PreferredName = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Salutation = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Position = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DateOfBirth = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DateRegistered = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Gender = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Password = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DateTaken = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Location = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Phone = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Email = DefaultAttributeHelper.INSTANCE;
    



    public CandidatePersistenceMgr ()
    {
        dummyFirstName = (String)(HELPER_FirstName.initialise (dummyFirstName));
        dummyMiddleName = (String)(HELPER_MiddleName.initialise (dummyMiddleName));
        dummyLastName = (String)(HELPER_LastName.initialise (dummyLastName));
        dummyPreferredName = (String)(HELPER_PreferredName.initialise (dummyPreferredName));
        dummySalutation = (String)(HELPER_Salutation.initialise (dummySalutation));
        dummyPosition = (String)(HELPER_Position.initialise (dummyPosition));
        dummyDateOfBirth = (Date)(HELPER_DateOfBirth.initialise (dummyDateOfBirth));
        dummyDateRegistered = (Date)(HELPER_DateRegistered.initialise (dummyDateRegistered));
        dummyGender = (String)(HELPER_Gender.initialise (dummyGender));
        dummyPassword = (String)(HELPER_Password.initialise (dummyPassword));
        dummyDateTaken = (Date)(HELPER_DateTaken.initialise (dummyDateTaken));
        dummyLocation = (String)(HELPER_Location.initialise (dummyLocation));
        dummyPhone = (String)(HELPER_Phone.initialise (dummyPhone));
        dummyEmail = (String)(HELPER_Email.initialise (dummyEmail));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}candidate.object_id as id, {PREFIX}candidate.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}candidate.object_CREATED_DATE as CREATED_DATE, {PREFIX}candidate.first_name, {PREFIX}candidate.middle_name, {PREFIX}candidate.last_name, {PREFIX}candidate.preferred_name, {PREFIX}candidate.salutation, {PREFIX}candidate.position, {PREFIX}candidate.date_of_birth, {PREFIX}candidate.date_registered, {PREFIX}candidate.gender, {PREFIX}candidate.password, {PREFIX}candidate.date_taken, {PREFIX}candidate.location, {PREFIX}candidate.contact_phone, {PREFIX}candidate.email,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Candidate.REFERENCE_Candidate);

                if (objectToReturn instanceof Candidate)
                {
                    LogMgr.log (CandidatePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Candidate");
                }
            }

            PersistentSet candidatePSet = allPSets.getPersistentSet(id, "candidate", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !candidatePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !candidatePSet.containsAttrib(Candidate.FIELD_FirstName)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_MiddleName)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_LastName)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_PreferredName)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_Salutation)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_Position)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_DateOfBirth)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_DateRegistered)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_Gender)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_Password)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_DateTaken)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_Location)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_Phone)||
                    !candidatePSet.containsAttrib(Candidate.FIELD_Email))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (CandidatePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Candidate result = new Candidate ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}candidate " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}candidate.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet candidatePSet = allPSets.getPersistentSet(objectID, "candidate");
            

            
            if (candidatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                candidatePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}candidate " +
                                                           "SET first_name = ?, middle_name = ?, last_name = ?, preferred_name = ?, salutation = ?, position = ?, date_of_birth = ?, date_registered = ?, gender = ?, password = ?, date_taken = ?, location = ?, contact_phone = ?, email = ? , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE candidate.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_FirstName.getForSQL(dummyFirstName, candidatePSet.getAttrib (Candidate.FIELD_FirstName))).listEntry (HELPER_MiddleName.getForSQL(dummyMiddleName, candidatePSet.getAttrib (Candidate.FIELD_MiddleName))).listEntry (HELPER_LastName.getForSQL(dummyLastName, candidatePSet.getAttrib (Candidate.FIELD_LastName))).listEntry (HELPER_PreferredName.getForSQL(dummyPreferredName, candidatePSet.getAttrib (Candidate.FIELD_PreferredName))).listEntry (HELPER_Salutation.getForSQL(dummySalutation, candidatePSet.getAttrib (Candidate.FIELD_Salutation))).listEntry (HELPER_Position.getForSQL(dummyPosition, candidatePSet.getAttrib (Candidate.FIELD_Position))).listEntry (HELPER_DateOfBirth.getForSQL(dummyDateOfBirth, candidatePSet.getAttrib (Candidate.FIELD_DateOfBirth))).listEntry (HELPER_DateRegistered.getForSQL(dummyDateRegistered, candidatePSet.getAttrib (Candidate.FIELD_DateRegistered))).listEntry (HELPER_Gender.getForSQL(dummyGender, candidatePSet.getAttrib (Candidate.FIELD_Gender))).listEntry (HELPER_Password.getForSQL(dummyPassword, candidatePSet.getAttrib (Candidate.FIELD_Password))).listEntry (HELPER_DateTaken.getForSQL(dummyDateTaken, candidatePSet.getAttrib (Candidate.FIELD_DateTaken))).listEntry (HELPER_Location.getForSQL(dummyLocation, candidatePSet.getAttrib (Candidate.FIELD_Location))).listEntry (HELPER_Phone.getForSQL(dummyPhone, candidatePSet.getAttrib (Candidate.FIELD_Phone))).listEntry (HELPER_Email.getForSQL(dummyEmail, candidatePSet.getAttrib (Candidate.FIELD_Email))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}candidate WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "candidate", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (CandidatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "candidate");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:candidate for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (CandidatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                candidatePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (CandidatePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet candidatePSet = allPSets.getPersistentSet(objectID, "candidate");
        

        LogMgr.log (CandidatePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (candidatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            candidatePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}candidate " +
                                                       "WHERE candidate.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}candidate WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "candidate");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:candidate for row:" + objectID;

                    LogMgr.log (CandidatePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            candidatePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Candidate> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Candidate.REFERENCE_Candidate.getObjectIDSpace (), r.getLong ("id"));
            Candidate resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Candidate.REFERENCE_Candidate);

                if (cachedElement instanceof Candidate)
                {
                    LogMgr.log (CandidatePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Candidate)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Candidate");
                }
            }
            else
            {
                PersistentSet candidatePSet = allPSets.getPersistentSet(objectID, "candidate", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Candidate ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (CandidatePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}candidate " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet candidatePSet = allPSets.getPersistentSet(objectID, "candidate", PersistentSetStatus.FETCHED);
        
            // Object Modified
            candidatePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            candidatePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        candidatePSet.setAttrib(Candidate.FIELD_FirstName, HELPER_FirstName.getFromRS(dummyFirstName, r, "first_name"));
        candidatePSet.setAttrib(Candidate.FIELD_MiddleName, HELPER_MiddleName.getFromRS(dummyMiddleName, r, "middle_name"));
        candidatePSet.setAttrib(Candidate.FIELD_LastName, HELPER_LastName.getFromRS(dummyLastName, r, "last_name"));
        candidatePSet.setAttrib(Candidate.FIELD_PreferredName, HELPER_PreferredName.getFromRS(dummyPreferredName, r, "preferred_name"));
        candidatePSet.setAttrib(Candidate.FIELD_Salutation, HELPER_Salutation.getFromRS(dummySalutation, r, "salutation"));
        candidatePSet.setAttrib(Candidate.FIELD_Position, HELPER_Position.getFromRS(dummyPosition, r, "position"));
        candidatePSet.setAttrib(Candidate.FIELD_DateOfBirth, HELPER_DateOfBirth.getFromRS(dummyDateOfBirth, r, "date_of_birth"));
        candidatePSet.setAttrib(Candidate.FIELD_DateRegistered, HELPER_DateRegistered.getFromRS(dummyDateRegistered, r, "date_registered"));
        candidatePSet.setAttrib(Candidate.FIELD_Gender, HELPER_Gender.getFromRS(dummyGender, r, "gender"));
        candidatePSet.setAttrib(Candidate.FIELD_Password, HELPER_Password.getFromRS(dummyPassword, r, "password"));
        candidatePSet.setAttrib(Candidate.FIELD_DateTaken, HELPER_DateTaken.getFromRS(dummyDateTaken, r, "date_taken"));
        candidatePSet.setAttrib(Candidate.FIELD_Location, HELPER_Location.getFromRS(dummyLocation, r, "location"));
        candidatePSet.setAttrib(Candidate.FIELD_Phone, HELPER_Phone.getFromRS(dummyPhone, r, "contact_phone"));
        candidatePSet.setAttrib(Candidate.FIELD_Email, HELPER_Email.getFromRS(dummyEmail, r, "email"));
        
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet candidatePSet = allPSets.getPersistentSet(objectID, "candidate");
        

        
        if (candidatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            candidatePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}candidate " +
                                     "  (first_name, middle_name, last_name, preferred_name, salutation, position, date_of_birth, date_registered, gender, password, date_taken, location, contact_phone, email,   object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,    ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_FirstName.getForSQL(dummyFirstName, candidatePSet.getAttrib (Candidate.FIELD_FirstName))).listEntry (HELPER_MiddleName.getForSQL(dummyMiddleName, candidatePSet.getAttrib (Candidate.FIELD_MiddleName))).listEntry (HELPER_LastName.getForSQL(dummyLastName, candidatePSet.getAttrib (Candidate.FIELD_LastName))).listEntry (HELPER_PreferredName.getForSQL(dummyPreferredName, candidatePSet.getAttrib (Candidate.FIELD_PreferredName))).listEntry (HELPER_Salutation.getForSQL(dummySalutation, candidatePSet.getAttrib (Candidate.FIELD_Salutation))).listEntry (HELPER_Position.getForSQL(dummyPosition, candidatePSet.getAttrib (Candidate.FIELD_Position))).listEntry (HELPER_DateOfBirth.getForSQL(dummyDateOfBirth, candidatePSet.getAttrib (Candidate.FIELD_DateOfBirth))).listEntry (HELPER_DateRegistered.getForSQL(dummyDateRegistered, candidatePSet.getAttrib (Candidate.FIELD_DateRegistered))).listEntry (HELPER_Gender.getForSQL(dummyGender, candidatePSet.getAttrib (Candidate.FIELD_Gender))).listEntry (HELPER_Password.getForSQL(dummyPassword, candidatePSet.getAttrib (Candidate.FIELD_Password))).listEntry (HELPER_DateTaken.getForSQL(dummyDateTaken, candidatePSet.getAttrib (Candidate.FIELD_DateTaken))).listEntry (HELPER_Location.getForSQL(dummyLocation, candidatePSet.getAttrib (Candidate.FIELD_Location))).listEntry (HELPER_Phone.getForSQL(dummyPhone, candidatePSet.getAttrib (Candidate.FIELD_Phone))).listEntry (HELPER_Email.getForSQL(dummyEmail, candidatePSet.getAttrib (Candidate.FIELD_Email)))  .listEntry (objectID.longID ()).toList().toArray());

            candidatePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
