
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class AnswerPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea AnswerPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Answer");

    // Private attributes corresponding to business object data
    private Integer dummyQuestionNo;
    private Integer dummyAnswerNo;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_QuestionNo = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_AnswerNo = DefaultAttributeHelper.INSTANCE;
    



    public AnswerPersistenceMgr ()
    {
        dummyQuestionNo = (Integer)(HELPER_QuestionNo.initialise (dummyQuestionNo));
        dummyAnswerNo = (Integer)(HELPER_AnswerNo.initialise (dummyAnswerNo));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}answer.object_id as id, {PREFIX}answer.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}answer.object_CREATED_DATE as CREATED_DATE, {PREFIX}answer.quest_number, {PREFIX}answer.answer_number, {PREFIX}answer.candidate_id, {PREFIX}answer.quest_number,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Answer.REFERENCE_Answer);

                if (objectToReturn instanceof Answer)
                {
                    LogMgr.log (AnswerPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Answer");
                }
            }

            PersistentSet answerPSet = allPSets.getPersistentSet(id, "answer", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !answerPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !answerPSet.containsAttrib(Answer.FIELD_QuestionNo)||
                    !answerPSet.containsAttrib(Answer.FIELD_AnswerNo)||
                    !answerPSet.containsAttrib(Answer.SINGLEREFERENCE_Candidate)||
                    !answerPSet.containsAttrib(Answer.SINGLEREFERENCE_Question))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (AnswerPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Answer result = new Answer ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}answer " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}answer.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet answerPSet = allPSets.getPersistentSet(objectID, "answer");
            

            
            if (answerPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                answerPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}answer " +
                                                           "SET quest_number = ?, answer_number = ?, candidate_id = ? , quest_number = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE answer.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_QuestionNo.getForSQL(dummyQuestionNo, answerPSet.getAttrib (Answer.FIELD_QuestionNo))).listEntry (HELPER_AnswerNo.getForSQL(dummyAnswerNo, answerPSet.getAttrib (Answer.FIELD_AnswerNo))).listEntry (SQLManager.CheckNull((Long)(answerPSet.getAttrib (Answer.SINGLEREFERENCE_Candidate)))).listEntry (SQLManager.CheckNull((Long)(answerPSet.getAttrib (Answer.SINGLEREFERENCE_Question)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}answer WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "answer", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (AnswerPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "answer");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:answer for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (AnswerPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                answerPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (AnswerPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet answerPSet = allPSets.getPersistentSet(objectID, "answer");
        

        LogMgr.log (AnswerPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (answerPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            answerPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}answer " +
                                                       "WHERE answer.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}answer WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "answer");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:answer for row:" + objectID;

                    LogMgr.log (AnswerPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            answerPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Answer> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Answer.REFERENCE_Answer.getObjectIDSpace (), r.getLong ("id"));
            Answer resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Answer.REFERENCE_Answer);

                if (cachedElement instanceof Answer)
                {
                    LogMgr.log (AnswerPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Answer)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Answer");
                }
            }
            else
            {
                PersistentSet answerPSet = allPSets.getPersistentSet(objectID, "answer", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Answer ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (AnswerPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}answer " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet answerPSet = allPSets.getPersistentSet(objectID, "answer", PersistentSetStatus.FETCHED);
        
            // Object Modified
            answerPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            answerPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        answerPSet.setAttrib(Answer.FIELD_QuestionNo, HELPER_QuestionNo.getFromRS(dummyQuestionNo, r, "quest_number"));
        answerPSet.setAttrib(Answer.FIELD_AnswerNo, HELPER_AnswerNo.getFromRS(dummyAnswerNo, r, "answer_number"));
        
        answerPSet.setAttrib(Answer.SINGLEREFERENCE_Candidate, r.getObject ("candidate_id"));
        answerPSet.setAttrib(Answer.SINGLEREFERENCE_Question, r.getObject ("quest_number"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet answerPSet = allPSets.getPersistentSet(objectID, "answer");
        

        
        if (answerPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            answerPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}answer " +
                                     "  (quest_number, answer_number,  candidate_id, quest_number,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_QuestionNo.getForSQL(dummyQuestionNo, answerPSet.getAttrib (Answer.FIELD_QuestionNo))).listEntry (HELPER_AnswerNo.getForSQL(dummyAnswerNo, answerPSet.getAttrib (Answer.FIELD_AnswerNo))) .listEntry (SQLManager.CheckNull((Long)(answerPSet.getAttrib (Answer.SINGLEREFERENCE_Candidate)))).listEntry (SQLManager.CheckNull((Long)(answerPSet.getAttrib (Answer.SINGLEREFERENCE_Question)))) .listEntry (objectID.longID ()).toList().toArray());

            answerPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
