<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran                 =   process.getTransaction ();
    String              nextPage                =   WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
    JobApplication      jobApplication          =   (JobApplication) process.getAttribute("JobApplication");
    Job                 job                     =   jobApplication.getJob();
    String              exitPage                =   WebUtils.getArticleLink(request, objTran, WebUtils.APPLY_JOB, "Page");
    exitPage                                    =   exitPage + "&id=" + job.getID() + "&key=" + job.getRandomKey();
    
//    Boolean             alreadyCompletedCulture =   (Boolean) process.getAttribute("AlreadyCompletedCulture");
//    Boolean             alreadyCompletedRole    =   (Boolean) process.getAttribute("AlreadyCompletedRole");
    Boolean             isCultureComplete       =   jobApplication.cultureCompleted();
    Boolean             isAssesmentComplete     =   jobApplication.assessmentCompleted();
    boolean             toRedirect              =   jobApplication.createAssessmentCriteriaObjects();
    
    if(isCultureComplete && isAssesmentComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    }
    else if(isCultureComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    }
    
    if (toRedirect)
    {
%>
        <%@ include file="/saferedirect.jsp" %>
<%  
    }
%>
    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
        });
        
        $(document.body).addClass('bg-color');
    </script>    

    <div class="main-application-outline">
        <div class="selection-aust-logo">
        <%
            if(job.isClientLogoAvailable())
            {
                int logoWidth   =   45;
        %>
                <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(job.getClient().getClientLogo()), "KEEP", new ScaleWithin (logoWidth, 0)) %>" />
        <%
            }
        %>
            <span><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></span>
            <div class="clearfix no-height"></div>
        </div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Requirements</div>
            <div class="mobile-estimated">Estimated time to complete: <b>5 mins</b></div>
        </div>
        <div class="section-c-title m-hide">
            Requirements
        <span class="estimated-time">Estimated time to complete:
            <span>5 mins</span>
        </span>
        </div>
        <div class="section-tab-view">
            
            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
            
                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="1"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area">
                    <div class="main-sc-section">
                        <p>
                            We'll ask you if you have certain skills, qualifications, knowledge, or experience that are somehow important to do this job.
                        </p>
                    </div>         
                    <%
                        FormTag     applicationForm =   FormTag.getActiveFormTag(request);
                        FormBuilder formBuilder     =   applicationForm.getFormBuilder();
                        
                        for(CriteriaType ct: CriteriaType.getCriteriaTypeArray())
                        {
                            Collection<AssessmentCriteriaAnswer>    answerList  =   jobApplication.getACAnswersByType(ct);

                            if(!answerList.isEmpty())
                            {
                    %>
                                <div class="selection-br-line"></div>
                                <div class="main-sc-section">
                                    <div class="selection-form-title"><oneit:toString value="<%= ct %>" mode="EscapeHTML"/></div>
                                    <%
                                        int total       =   answerList.size();
                                        int answerNo    =   1;
                                        
                                        for(AssessmentCriteriaAnswer answer: answerList)
                                        {
                                            String  optionKey       =   WebUtils.getInputKey(request, answer, AssessmentCriteriaAnswer.FIELD_Answer);
                                            String  formValue       =   formBuilder.fieldValue (optionKey, answer.getAnswer() == null ? "" : String.valueOf(answer.getAnswer()));
                                            String  trueID          =   answer.getObjectID() + "_Y";
                                            String  falseID         =   answer.getObjectID() + "_N";
                                            String  trueSelected    =   CollectionUtils.equals("true", formValue) ? "checked" : "";
                                            String  falseSelected   =   CollectionUtils.equals("false", formValue) ? "checked" : "";
                                    %>
                                            <div class="form-group-new question-y-n">
                                                <label class="second-label">
                                                    <oneit:toString value="<%= answer.getAssessmentCriteria() %>" mode="EscapeHTML"/>
                                                </label>
                                                <div class="radio radio-primary second-radio-primary">
                                                    <input type="radio" name="<%= optionKey %>" value="true"    id="<%= trueID%>" <%= trueSelected %>/>
                                                    <label for="<%= trueID%>">
                                                        Yes
                                                    </label>
                                                </div>
                                                <div class="radio radio-primary second-radio-primary">
                                                    <input type="radio" name="<%= optionKey %>" value="false"   id="<%= falseID%>" <%= falseSelected %>/>
                                                    <label for="<%= falseID%>">
                                                        No
                                                    </label>
                                                </div>
                                            </div>           
                                            
                                            <oneit:recalcClass  htmlTag="div"  classScript="answer.getAnswer() != null && answer.getAnswer() ? 'show': 'hide'"    answer="<%= answer %>">
                                                <div class="textarea-box"> 
                                                    <oneit:ormtextarea  obj="<%= answer %>" attributeName="Notes"   cssClass="form-control second-style"
                                                                            placeholder="Please add any notes to support your answer"/>
                                                </div>
                                            </oneit:recalcClass>
                                            <%
                                                if(answerNo++<total)
                                                {
                                            %>
                                                    <div class="section-br-inside"></div>
                                            <%
                                                }
                                            %>
                                    <%
                                        }
                                    %>
                                </div>
                    <%
                            }
                        }
                    %>
                    <div class="selection-br-line"></div>
                    <div class="main-sc-section-bottom btn-remove-padd">
                        <div class="section-btn text-center">
                            <oneit:button   value="Save and exit"   name="saveAndExitExperienece"   cssClass="box-btn-gray"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", exitPage)
                                                                            .mapEntry ("JobApplication", jobApplication)
                                                                            .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                            .toMap() %>"/>
                            <%
                                if(isCultureComplete && isAssesmentComplete)
                                {
                            %>
                                    <oneit:button   value="Complete"    name="completeApplication"  id="nextButton"  cssClass="box-btn"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                                        .mapEntry("restartProcess", Boolean.TRUE)
                                                                                        .toMap() %>"/>
                            <%
                                }
                                else
                                {
                            %>
                                    <oneit:button   value="Proceed to next step"   name="gotoPage" cssClass="box-btn"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>"/>
                            <%
                                }
                            %>
                        </div>
                    </div>
                </div>
            </oneit:form>
        </div>
    </div>
</oneit:dynIncluded>