<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         =   (Job) process.getAttribute("Job");
    String  samePage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA);
    String  nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.WORKPLACE_CULTURE);
    String  jobPage     =   WebUtils.getSamePageInRenderMode(request, "Page");

    Debug.assertion(job != null, "Job is null in admin portal create job");
%>

    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc ($("form#editJob"), {'recalcOnError':true});
          
            $(".switch input[type='checkbox']").change(function() {
                $("button[name$='changeAssessmentCriteria']").click();
            });
            
            $("#assessmentCriteriaSection").on("ormtable_row_post_delete", function (){
               recalcFunction();
            });
            
            $("select[name$='AssessmentTemplate']").change(function(){
                $("button[name$='loadRequirementsFromTemplate']").click();
            });
            
            var showError = true;

            addPostRecalcHandler (function ($fieldThatChanged) {
                if(showError) {
                    showError = false;
                    $('.errorField input, .errorField select, .errorField textarea, .errorField .assocObjDesc').eq(0).focus();
                }
                
                //recalcFunction();
            });
        });
        
        function addCriteria(criteria) 
        {
            var divID = "#" + criteria;
            
            ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/adminportal/inc/job_assessment_criteria_add.jsp", divID, {'CriteriaName' : criteria}, function (theHTML_JQ) {
                $(divID + "> #assessmentCriteriaSection").append (theHTML_JQ);
            });
        }
        
        function deleteCriteria(deleteVarKey, criteriaID)
        {
            ajaxProcessDeleteJQ("<%= request.getContextPath() %>/genericDelete_AJAX.jsp", "#" + criteriaID , { varKey: deleteVarKey });
            return false;
        }
    </script>
    
    <oneit:form name="editJob"  method="post"   enctype="multipart/form-data">

        <div class="container-fluid">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <h1 class="page-title">Create a job</h1>

            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="2"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <%
                job.setCompletedRequirements(Boolean.TRUE);
            %>
            
            <div class="form-page-area nopadding">
                <div class="create-job">
                    <div class="form-page-section">
                        <div class="form-group">
                            <label>Include Requirements for this Job?</label>
                            <span class="pull-right">
                                <label class="switch">
                                    <oneit:recalcClass  htmlTag="span"  classScript="job.showAssessmentCriteriaSection() ? 'checkbox checked': 'checkbox unchecked'"    job="<%= job %>">
                                        <oneit:ormInput obj="<%= job %>"    attributeName="IncludeAssessmentCriteria"   type="checkbox"/>
                                    </oneit:recalcClass>
                                    <div class="slider round"></div>
                                </label>
                                <oneit:button   value=" "    name="changeAssessmentCriteria"    cssClass="hide"
                                                requestAttribs="<%= CollectionUtils.mapEntry ("Job", job)
                                                                                .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                                .toMap() %>" />
                            </span>
                        </div>
                        
                        <oneit:recalcClass  htmlTag="div"   classScript="job.showAssessmentCriteriaSection() ? 'show': 'hide'"  job="<%= job %>">
                        <%
                            if(job.getAssessmentTemplate() != null)
                            {
                        %>
                                <div class="info-box">
                                    <div class="info-title">
                                        Template : <strong><%= job.getAssessmentTemplate().getTemplateName() %></strong>
                                    </div>
                                    <div class="info-desc">
                                        Changing requirement below is possible and will not overwrite <strong><%= job.getAssessmentTemplate().getTemplateName() %></strong>, OR <strong>Job Details</strong> as already defined, however they will need to be saved if you wish to use them again (which also includes Job Details).
                                    </div>
                                </div>
                        <%
                            }
                        %>
                        <div class="warning-box">
                            Requirements marked as Essential will be mandatory for any applicant applying for this job
                        </div>
                        
                            <div class="form-brack-line-sub"></div> 
                        <%
                            for(CriteriaType criteria : CriteriaType.getCriteriaTypeArray())
                            {
                                String  name    =   criteria.getName();
                        %>
                                <div class="form-group">
                                    <div class="form-group"  id="<%= name%>">
                                        <div class="form-medium-title qualification-title">

                                            <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/>

                                            <span class="skill-label">

                                                <oneit:recalcClass htmlTag="span"   class="skill-label" classScript="job.getAssessmentCriteraCountByType(criteria) > 0 ? 'show': 'hide'" job="<%= job %>"    criteria="<%= criteria %>">
                                                    <oneit:recalc   script="job.getAssessmentCriteraCountByType(criteria)"  mode="EscapeHTML"   job="<%= job %>"    criteria="<%= criteria %>" />
                                                    <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/> added
                                                </oneit:recalcClass>

                                                <oneit:recalcClass htmlTag="span"   class="skill-label" classScript="job.getAssessmentCriteraCountByType(criteria) > 0 ? 'hide': 'show'" job="<%= job %>"    criteria="<%= criteria %>">
                                                    <span class="skill-label">No required <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/><%= criteria.getIsSingular() ? " has" : " have"%> been added.</span>
                                                </oneit:recalcClass>

                                            </span>
                                        </div>
                                        <div id="assessmentCriteriaSection">
                                        <%
                                            for (AssessmentCriteria assessmentCriteria : job.getAssessmentCriteraByType(criteria))
                                            {
                                        %>
                                                <oneit:dynInclude   page="/extensions/adminportal/inc/job_assessment_criteria_add.jsp"  AssessmentCriteria="<%= assessmentCriteria %>"
                                                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>
                                        <%
                                            }
                                        %>
                                        </div>
                                    </div>
                                    <div class="main-add-more">
                                        <oneit:button   value="<%= "Add " + name%>"  name="newAssessmentCriteria"   cssClass="add-more-btn" skin="link"
                                                        onClick="<%="addCriteria('" + name + "'); return false;"%>"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", samePage).toMap() %>"/>
                                    </div>
                                </div>
                                <div class="form-brack-line-sub"></div>
                        <%
                            }
                        %>   
                        </oneit:recalcClass>
                        
                        <div class="form-group">
                            <div class="styled_checkboxes">
                                <div class="checkbox checkbox-primary">
                                    <oneit:ormInput obj="<%= job %>"  id="save-assess-check"  attributeName="SaveAssessmentTemplate"  type="checkbox"/>
                                    <oneit:recalcClass  htmlTag="span"  classScript="job.showSaveAssessmentTemplate() ? 'checked': 'unchecked'" job="<%= job %>">
                                        <label for="save-assess-check">
                                            <oneit:label GUIName="Save Job Details and Requirements as a new template (this will not publish the Job)" />
                                        </label>
                                    </oneit:recalcClass>
                                </div>
                            </div>
                        </div>
                        <oneit:recalcClass  htmlTag="div"   classScript="job.showSaveAssessmentTemplate() ? 'form-group template-save show': 'form-group template-save hide'"   job="<%= job %>">
                            <div class="input-group input-group-lg">
                                <div class="icon-addon addon-lg">
                                    <oneit:ormInput obj="<%= job %>"    type="text" attributeName="AssessmentTemplateName"  cssClass="form-control" />
                                </div>
                                <span class="input-group-btn">
                                    <oneit:button   value="SAVE"    name="saveRequirementTemplate"  cssClass="btn btn-primary"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("Job", job)
                                                                                        .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                                        .toMap() %>" />
                                </span>
                            </div>
                        </oneit:recalcClass>
                 
                        <div class="text-center">
                            <oneit:button   value="Save as draft"   name="saveJob"  cssClass="btn btn-primary top-margin-25 largeBtn greyBtn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage)
                                                                                .mapEntry("DraftLocation", DraftLocation.ASSESSMENT)
                                                                                .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                                .toMap() %>"/>
                            <oneit:button   value="Proceed to Culture"  name="processCulture" cssClass="btn btn-primary top-margin-25 largeBtn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .mapEntry("fromAssessment", true)
                                                                            .toMap() %>" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>