package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.MultiException;
import oneit.utils.filter.Filter;
import performa.orm.AnswerOption;
import performa.orm.Candidate;
import performa.orm.CandidateDiversityAnswer;
import performa.orm.HTDiversityQuestion;
import performa.orm.Job;
import performa.orm.JobApplication;


public class SaveDiversityAnswersFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request         =   submission.getRequest();
        JobApplication      jobApplication  =   (JobApplication) request.getAttribute("JobApplication");
        
        LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING1,"In SaveDiversityAnswersFP saving job application: ", jobApplication );

        Candidate           candidate       =   jobApplication.getCandidate();
        Job                 job             =   jobApplication.getJob();
        
        for(HTDiversityQuestion htQuestion : job.getDiversityQuestions())
        {
            CandidateDiversityAnswer    diversityAnswer =   candidate.getDiversityAnswerByQuestion(htQuestion.getQuestion());
            
            for(AnswerOption answer : diversityAnswer.getAnswersSet())
            {
                if(!answer.isTrue(answer.getIsSelected()))
                {
                    LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING1,"In SaveDiversityAnswersFP deleting AnswerOption : ", answer );

                    answer.delete();
                }
            }
        }
        
        return super.processForm(process, submission, params);
    }
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request         =   submission.getRequest();
        JobApplication      jobApplication  =   (JobApplication) request.getAttribute("JobApplication");
        Candidate           candidate       =   jobApplication.getCandidate();
        Job                 job             =   jobApplication.getJob();
        
        for(HTDiversityQuestion htQuestion : job.getDiversityQuestions())
        {
            CandidateDiversityAnswer    diversityAnswer =   candidate.getDiversityAnswerByQuestion(htQuestion.getQuestion());
            Filter<AnswerOption>        filter          =   AnswerOption.SearchByAll().andIsSelected(new EqualsFilter<>(Boolean.TRUE));

            BusinessObjectParser.assertFieldCondition(diversityAnswer.pipelineCandidateDiversityAnswer().toAnswers(filter).uniqueVals().size() >= 1 , diversityAnswer, CandidateDiversityAnswer.MULTIPLEREFERENCE_Answers, "atleastOneAnswer", exceptions, true, request);
        }
        
        super.validate(process, submission, exceptions, params);
    }
}