<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<%
    Job     job         = (Job) process.getAttribute("Job");

    if(job==null && request.getParameter("JobID")!=null)
    {
       job  =  Job.getJobByID(transaction, Long.parseLong(request.getParameter("JobID")));
       
       process.setAttribute("Job", job);
    }
    
    Debug.assertion(job != null, "Job is null in admin portal view applicants");

    String          applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    String          currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.APPLICANTS_GRID);
    AppSortOption   appSortOpt      =   (AppSortOption) process.getAttribute("AppSortOption");

    if(request.getParameter("AppSortOption") != null)
    {
        appSortOpt  =   AppSortOption.forName((String) request.getParameter("AppSortOption"));
    }
    
    if(appSortOpt == null)
    {
        appSortOpt  =   AppSortOption.RANK;
    }
    
    JobApplication[]        applications        =   (JobApplication[]) process.getAttribute("ShortListedApplications");
    
    if(applications==null)
    {
        applications    =   job.getShortlistedApplications() != null ? job.getShortlistedApplications().toArray(new JobApplication[0]) : null;
        
        process.setAttribute("ShortListedApplications", applications);
    }
    
    List<JobApplication>    sortedApplications  =   applications!=null ? Utils.getApplicationsSorted(applications, appSortOpt) : new ArrayList<JobApplication>();

    process.setAttribute("AppSortOption", appSortOpt);
%>

    <script type="text/javascript">
        $(document).ready(function()
        {
            $('.grid-box-view').slick({
                dots: false,
                infinite: false,
                speed: 300,
                slidesToShow: 5,    
                nextArrow: "<div class='sl_width slider-next'><span><img src='images/slider-arrow.png' /></span></div>",
                prevArrow: "<div class='sl_width slider-prev'><span><img src='images/slider-arrow-left.png' /></span></div>",
                responsive: [
                {
                  breakpoint: 1280,
                  settings: {
                    slidesToShow: 4
                  }
                },
                {
                  breakpoint: 1024,
                  settings: {
                    slidesToShow: 3
                  }
                },
                {
                  breakpoint: 600,
                  settings: {
                    slidesToShow: 2
                  }
                },
                {
                  breakpoint: 480,
                  settings: {
                    slidesToShow: 1
                  }
                }
              ]
            });
            
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
        });
    </script>
    
    <oneit:form name="viewApplicants" method="post"    enctype="multipart/form-data">

        <div class="dashboard-content-area">
            
            <oneit:dynInclude   page="/extensions/adminportal/inc/applicant_view_tabs.jsp"  TabNumber="2"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <div class="second-part view-app-area">            

                <oneit:dynInclude   page="/extensions/adminportal/inc/application_sorting_bar.jsp"  
                                    sortOption="<%= appSortOpt %>"
                                    currentPage="<%= currentPage %>"
                                    tabNumber="2"
                                    isShortList="<%= Boolean.TRUE %>"
                                    showOrderBy="<%= sortedApplications.size() > 1 %>"
                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>

            
                <div class="five-boxs grid-box-view" style="">
                    <%
                        int i   = 0;

                        for(JobApplication jobApplication : sortedApplications)
                        {
                            Candidate   candidate   =   jobApplication.getCandidate();
                            String      appID       =   "app-id-" + jobApplication.getID().toString();
                            Integer     overallRank =   jobApplication.getOverallRank();
                            Boolean     isTopRank   =   CollectionUtils.equals(overallRank, 1);
                            
                            Map<FactorClass, Tuple.T2<Double, ColorCode>>   roleScoreMap    =   (Map<FactorClass, Tuple.T2<Double, ColorCode>>)jobApplication.getRoleFit();
                    %>
                            <div class="<%= "appl-c-box " + (i == 0 ? " cb-one" : "")%> ">
                                <!--TODO: need to work on the logic. just added to demonstrate that there are 3 different colors for this-->
                                <div class="cb-title dark-back ">
                                    <div class="checkbox-list grid-checkbox">
                                        <div class="checkbox-list">
                                            <input type="checkbox"  name="IsSelected" value="<%= jobApplication.getObjectID().toString() %>"  id="<%= appID %>" class="applicant" >
                                            <label for="<%= appID %>">
                                                <oneit:toString value="<%= candidate %>"    mode="EscapeHTML" />
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <oneit:button   value=" "   name="gotoPage" skin="link"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).mapEntry("Applications", sortedApplications).toMap())
                                                                                .toMap() %>">
                                    <div class="overall-suitablity grid-suitability">
                                        <div class="<%= "over-all blue " + (isTopRank ? "f-60" : "")%>">
                                            <oneit:toString value="<%= overallRank %>"   mode="Integer" />
                                        </div>
                                        <div class="<%= "overall " + (isTopRank ? "f-60" : "")%>">overall rank</div>
                                    </div>
                                    <div class="jcc-box">
                                        <div class="job-match jcc">
                                            <img src="images/app-job-match-icon.svg"> Role fit 
                                            <span><oneit:toString value="<%= jobApplication.getRoleFitPercentage() %>"  mode="PercentageTwoDP" /></span>
                                        </div>
                                        <div class="detail-box">
                                        <%
                                            for(FactorClass factorClass : jobApplication.getSortedFactorClasses())
                                            {
                                                if(factorClass != null && roleScoreMap.get(factorClass) != null)
                                                {
                                        %>
                                                    <div class="detail-row">
                                                        <div class="detail-label">
                                                            <oneit:toString   value="<%= factorClass %>"    mode="EscapeHTML"/>
                                                        </div>
                                                        <div class="detail-no green">
                                                            <oneit:toString  value="<%= roleScoreMap.get(factorClass).get0() %>"    mode="PercentageWholeNumber"/>
                                                        </div>
                                                    </div>   
                                        <%
                                                }
                                            }
                                        %>
                                        </div>
                                        <div class="culture jcc">
                                            <img src="images/culture-icon.svg"> culture fit
                                            <span>
                                                <oneit:button   value=" "   name="gotoPage" skin="link"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                                .toMap() %>">
                                                    <oneit:toString value="<%= jobApplication.getCultureFitScore() %>"  mode="PercentageWholeNumber" />
                                                </oneit:button>
                                            </span>
                                        </div>
                                        <div class="detail-box">
                                            <%
                                                Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>    cultureFitData  =   (Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>)jobApplication.getCultureFit();

                                                for(CultureClass cClass: cultureFitData.keySet())
                                                {
                                                    if(cClass==null)
                                                    {
                                                        continue;
                                                    }
                                            %>
                                                    <div class="detail-row">
                                                        <div class="detail-label"><oneit:toString   value="<%= cClass %>"   mode="EscapeHTML"/></div>
                                                        <div class="detail-no green"><oneit:toString    value="<%= cultureFitData.get(cClass) != null ? cultureFitData.get(cClass).get0() : 0 %>"   mode="PercentageWholeNumber" /></div>
                                                    </div>
                                            <%
                                                }
                                            %>
                                        </div>
                                    <%
                                        if(job.getIncludeAssessmentCriteria()==Boolean.TRUE)
                                        {
                                    %>
                                            <div class="jcc">
                                                <img src="images/criteria-icon.svg"> Requirements 
                                                <span>
                                                    <oneit:button   value=" "   name="gotoPage" skin="link"
                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                                    .toMap() %>">
                                                        <oneit:toString value="<%= jobApplication.getRequirementFitScore() %>"   mode="PercentageWholeNumber" />
                                                    </oneit:button>
                                                </span>
                                            </div>
                                            <div class="detail-box">
                                            <%
                                                Map<Importance, Long>   requirementFitData  =   (Map<Importance, Long>)jobApplication.getRequirementFit();

                                                for(Importance importance: Utils.getImportancesForAssessment())
                                                {
                                            %>
                                                    <div class="detail-row">
                                                        <div class="detail-label"><oneit:toString   value="<%= importance %>"   mode="EscapeHTML"/></div>
                                                        <div class="detail-no green"><oneit:toString    value="<%= requirementFitData.get(importance) %>"   mode="PercentageWholeNumber" /></div>
                                                    </div>
                                            <%
                                                }
                                            %>
                                            </div>
                                    <%
                                        }
                                    %>
                                    </div>
                                </oneit:button>
                            </div>
                    <%
                            i++;
                        }
                    %>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>