package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.*;
import performa.orm.*;
 

public class VerifyIdentityFP extends SaveFP
{
    private static LoggingArea  LOG =   LoggingArea.createLoggingArea("VerifyIdentity");
    
    @Override
    protected Map validate(SubmissionDetails submission, MultiException exceptions) 
    {
        HttpServletRequest  request     =   submission.getRequest();
        Job                 job         =   (Job) request.getAttribute("Job");
        Candidate           candidate   =   (Candidate) request.getAttribute("Candidate");
        SecUser             secUser     =   candidate.getUser();

        if(secUser.getUserName() != null)
        {
            BusinessObjectParser.assertFieldCondition(StringUtils.isEmailAddress(secUser.getUserName()), job, Job.FIELD_Email, "invalid", exceptions, true, request);
        }
        
        BusinessObjectParser.assertFieldCondition(secUser.getFirstName() != null, secUser, SecUser.FIELD_FirstName, "mandatory", exceptions, true, request);
        BusinessObjectParser.assertFieldCondition(secUser.getLastName() != null, secUser, SecUser.FIELD_LastName, "mandatory", exceptions, true, request);
        
        return super.validate(submission, exceptions);
    }
}