import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { MessageService } from 'primeng/api';
import { HomeGuard } from './guards/home.guard';
import { PublicGuard } from './guards/public.guard';

import { WrapperComponent } from './layouts/wrapper/wrapper.component';
import { McSharedModule } from './mc-shared/mc-shared.module';
import { MyCareerWebRouting } from './my-career-web.routing';
import { AuthService } from './services/auth.service';
import { WelcomeComponent } from './welcome/welcome.component';

@NgModule({
    imports: [
        CommonModule,
        McSharedModule,
        MyCareerWebRouting
    ],
    providers: [
        AuthService,
        MessageService,
        PublicGuard,
        HomeGuard
    ],
    declarations: [
        WrapperComponent,
        WelcomeComponent
    ]
})
export class MyCareerWebModule {
}
