import { Component } from '@angular/core';
import { takeUntil } from 'rxjs/operators';
import { AuthService } from '../../services/auth.service';
import { Router } from '@angular/router';
import { BaseComponent } from '../../base/base.component';

@Component({
    selector: 'app-left-sidebar',
    templateUrl: './left-sidebar.component.html',
    styleUrls: ['./left-sidebar.component.scss']
})
export class LeftSidebarComponent extends BaseComponent {

    constructor(
        private as: AuthService,
        private r: Router
    ) {
        super();
    }

    logout(): void {
        this.isLoading = true;
        this.as.logout()
            .pipe(takeUntil(this.componentInView))
            .subscribe(() => {
                this.r.navigate(['/my-career-web/auth/login']);
                this.isLoading = false;
            });
    }

}
