import { HostListener, OnDestroy, OnInit } from '@angular/core';
import { Subject } from 'rxjs';

export class BaseComponent implements OnInit, OnDestroy {

    isEditMode = false;
    isLoading = false;
    isMobileView = false;
    resizeTimeout = 500;

    protected componentInView = new Subject();

    @HostListener('window:resize')
    onWindowResize() {
        //debounce resize, wait for resize to finish before doing stuff
        if (this.resizeTimeout) {
            clearTimeout(this.resizeTimeout);
        }
        this.resizeTimeout = setTimeout((() => {
            this.isMobileView = document.body.getBoundingClientRect().width <= 600;
        }), 500);
    }

    ngOnInit(): void {
        this.isMobileView = document.body.getBoundingClientRect().width <= 600;
    }


    ngOnDestroy(): void {
        this.componentInView.next();
        this.componentInView.complete();
    }

}
