package performa.orm;

import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.rdbms.filters.IsNotNullFilter;
import oneit.utils.math.NullArith;


public class PaymentPlan extends BasePaymentPlan
{
    private static final long   serialVersionUID    =   0L;
    public static final Double  PER_PER_JOB_AMOUNT  =   499D; 
    
    // This constructor should not be called
    public PaymentPlan ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    
    @Override
    public String getToString() 
    {
        if(getActiveJobCount()!=null)
        {
            return getActiveJobCount().toString();
        }
        
        return super.getToString();
    }
    
    
    public Double getPerMonthSaveAmount()
    {
        if(getActiveJobCount()!=null)
        {
            return NullArith.subtract(NullArith.multiply(getActiveJobCount(), PER_PER_JOB_AMOUNT, 0D), getAmount(), 0D);
        }
        
        return null;
    }
}