import { Injectable } from '@angular/core';
import { Observable, Subject } from 'rxjs';
import { EnumService } from '../../oneit/services/enum.service';
import { SaveService } from '../../oneit/services/save.service';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { SERVICES } from '../config/constants';
import { CareerProfileModel } from '../models/career-profile.model';

@Injectable()

export class PersonalDetailsService {

    private _detailsUpdated = new Subject<CareerProfileModel>();

    get careerProfileUpdated$(): Observable<CareerProfileModel> {
        return this._detailsUpdated.asObservable();
    }

    set careerProfileUpdated(profile: CareerProfileModel) {
        this._detailsUpdated.next(profile);
    }

    private _currentTabSubject = new Subject<any>();

    get currentTab$(): Observable<any> {
        return this._currentTabSubject.asObservable();
    }

    set currentTab(value: any) {
        this._currentTabSubject.next(value);
    }

    constructor(
        private enumService: EnumService,
        private utilsService: UtilsService,
        private searchService: SearchService,
        private saveService: SaveService
    ) {
    }

    getEmploymentStatuses(): Observable<any> {
        return this.enumService.getEnums('EmploymentStatuses', true);
    }

    getEmploymentPreferences(): Observable<any> {
        return this.enumService.getEnums('EmploymentPreferences', true);
    }

    getJobTitles(queryParams = {}, assocs = []): Observable<any> {
        return this.searchService.getObjects(SERVICES.JOB_TITLES, 'All', queryParams, assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            )
    }

    getSkills(queryParams = {}, assocs = []): Observable<any> {
        return this.searchService.getObjects(SERVICES.SKILLS, 'All', queryParams, assocs, null, null, null, null)
          .map(
            data => {
                return this.utilsService.convertResponseToObjects(data, assocs);
            }
          )
    }

    getCertifications(queryParams = {}, assocs = []): Observable<any> {
        return this.searchService.getObjects(SERVICES.CERTIFICATIONS, 'All', queryParams, assocs, 'Autocomplete', null, null, null)
          .map(
            data => {
                return this.utilsService.convertResponseToObjects(data, assocs);
            }
          )
    }

    getSkillRatings(): Observable<any> {
        return this.enumService.getEnums('SkillRatings', true);
    }

    getCareerProfile(assocs = []): Observable<CareerProfileModel> {
        return this.searchService.getObjects(SERVICES.CAREER_PROFILES, 'All', {}, assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs)[0];
                }
            )
    }

    saveProfile(createdObjs, updatedObjs, deletedObjs): Observable<any> {
        return this.saveService.saveObjects('svc/SavePersonalDetails',createdObjs, updatedObjs, deletedObjs);
    }

    saveProfileDefault(createdObjs, updatedObjs, deletedObjs): Observable<any> {
        return this.saveService.saveObjectsWithDefaultSvc(createdObjs, updatedObjs, deletedObjs);
    }

}
