import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';

import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class MessageEngineService {
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }

    getJobApplicationByID(id, assocs): Observable<any> {
        return this.searchService.getObjectById('JobApplications', id, assocs)
            .map(
                data => {
                    const objs = this.utilsService.convertResponseToObjects(data, assocs);

                    if (objs && objs.length > 0) {
                        return objs[0];
                    }
                }
            );
    }
}
