import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SearchService } from './../../oneit/services/search.service';
import { ListMessageTemplateService } from './list-message-template.service';

import { ListMessageTemplate } from './list-message-template.model';

@Component({
    selector: 'app-list-message-template',
    templateUrl: './list-message-template.component.html'
})
export class ListMessageTemplateComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    listMessageTemplate : ListMessageTemplate = new ListMessageTemplate();
    messageTemplates: any[] = [];
    showResults: boolean = false;
    messageTemplatesCols = [
        { field: '', header: '', width: '4%', noSort: true, noFilter: true},
        { field: 'Description', header: 'Description', width: '85%', noSort: false, noFilter: false},
        { field: 'Disabled', header: 'Disabled', width: '11%', noSort: true, noFilter: true}
    ];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private searchService: SearchService,
        private appService: AppService,
        private listMessageTemplateService: ListMessageTemplateService
    ){
        
    }

    ngOnInit() {

        this.searchService.getLastSearchRequest("ListMessageTemplate").subscribe(
            data => {
                if (data != null) {
                    this.listMessageTemplate = data.queryParams;
                    this.getMessageTemplates(false);
                }
            }
        );
    }
    

    getMessageTemplates(saveSearch: boolean) {
        
        this.showResults    =   true;
        this.showLoader     =   true;
        let assocs          =   [];
        
        this.subscriptions.push(this.listMessageTemplateService.getMessageTemplates(this.listMessageTemplate, assocs, saveSearch)
            .subscribe(
                data => {
                    this.messageTemplates = data;
                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
        
    onRowSelect(data) {
        this.router.navigate(['/XXXX', data.ObjectID]);
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}