
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;
import oneit.security.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class JobPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea JobPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Job");

    // Private attributes corresponding to business object data
    private String dummyJobTitle;
    private String dummyJobDescription;
    private JobStatus dummyJobStatus;
    private Date dummyOpenDate;
    private Date dummyApplyBy;
    private Boolean dummyIncludeAssessmentCriteria;
    private AssessmentType dummyAssessmentType;
    private String dummyRandomKey;
    private JobType dummyJobType;
    private String dummyReferenceNumber;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_JobTitle = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_JobDescription = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_JobStatus = new EnumeratedAttributeHelper (JobStatus.FACTORY_JobStatus);
    private static final DefaultAttributeHelper HELPER_OpenDate = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ApplyBy = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IncludeAssessmentCriteria = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_AssessmentType = new EnumeratedAttributeHelper (AssessmentType.FACTORY_AssessmentType);
    private static final DefaultAttributeHelper HELPER_RandomKey = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_JobType = new EnumeratedAttributeHelper (JobType.FACTORY_JobType);
    private static final DefaultAttributeHelper HELPER_ReferenceNumber = DefaultAttributeHelper.INSTANCE;
    



    public JobPersistenceMgr ()
    {
        dummyJobTitle = (String)(HELPER_JobTitle.initialise (dummyJobTitle));
        dummyJobDescription = (String)(HELPER_JobDescription.initialise (dummyJobDescription));
        dummyJobStatus = (JobStatus)(HELPER_JobStatus.initialise (dummyJobStatus));
        dummyOpenDate = (Date)(HELPER_OpenDate.initialise (dummyOpenDate));
        dummyApplyBy = (Date)(HELPER_ApplyBy.initialise (dummyApplyBy));
        dummyIncludeAssessmentCriteria = (Boolean)(HELPER_IncludeAssessmentCriteria.initialise (dummyIncludeAssessmentCriteria));
        dummyAssessmentType = (AssessmentType)(HELPER_AssessmentType.initialise (dummyAssessmentType));
        dummyRandomKey = (String)(HELPER_RandomKey.initialise (dummyRandomKey));
        dummyJobType = (JobType)(HELPER_JobType.initialise (dummyJobType));
        dummyReferenceNumber = (String)(HELPER_ReferenceNumber.initialise (dummyReferenceNumber));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_job.object_id as id, {PREFIX}tl_job.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_job.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_job.job_title, {PREFIX}tl_job.job_description, {PREFIX}tl_job.job_status, {PREFIX}tl_job.open_date, {PREFIX}tl_job.apply_by, {PREFIX}tl_job.include_assessment_criteria, {PREFIX}tl_job.assessment_type, {PREFIX}tl_job.random_key, {PREFIX}tl_job.job_type, {PREFIX}tl_job.ref_number, {PREFIX}tl_job.level_id, {PREFIX}tl_job.secuser_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Job.REFERENCE_Job);

                if (objectToReturn instanceof Job)
                {
                    LogMgr.log (JobPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Job");
                }
            }

            PersistentSet tl_jobPSet = allPSets.getPersistentSet(id, "tl_job", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_jobPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_jobPSet.containsAttrib(Job.FIELD_JobTitle)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_JobDescription)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_JobStatus)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_OpenDate)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_ApplyBy)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_IncludeAssessmentCriteria)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_AssessmentType)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_RandomKey)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_JobType)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_ReferenceNumber)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_Level)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_SecUser))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (JobPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Job result = new Job ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_job " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_job.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job");
            

            
            if (tl_jobPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_jobPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_job " +
                                                           "SET job_title = ?, job_description = ?, job_status = ?, open_date = ?, apply_by = ?, include_assessment_criteria = ?, assessment_type = ?, random_key = ?, job_type = ?, ref_number = ?, level_id = ? , secuser_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_job.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_JobTitle.getForSQL(dummyJobTitle, tl_jobPSet.getAttrib (Job.FIELD_JobTitle))).listEntry (HELPER_JobDescription.getForSQL(dummyJobDescription, tl_jobPSet.getAttrib (Job.FIELD_JobDescription))).listEntry (HELPER_JobStatus.getForSQL(dummyJobStatus, tl_jobPSet.getAttrib (Job.FIELD_JobStatus))).listEntry (HELPER_OpenDate.getForSQL(dummyOpenDate, tl_jobPSet.getAttrib (Job.FIELD_OpenDate))).listEntry (HELPER_ApplyBy.getForSQL(dummyApplyBy, tl_jobPSet.getAttrib (Job.FIELD_ApplyBy))).listEntry (HELPER_IncludeAssessmentCriteria.getForSQL(dummyIncludeAssessmentCriteria, tl_jobPSet.getAttrib (Job.FIELD_IncludeAssessmentCriteria))).listEntry (HELPER_AssessmentType.getForSQL(dummyAssessmentType, tl_jobPSet.getAttrib (Job.FIELD_AssessmentType))).listEntry (HELPER_RandomKey.getForSQL(dummyRandomKey, tl_jobPSet.getAttrib (Job.FIELD_RandomKey))).listEntry (HELPER_JobType.getForSQL(dummyJobType, tl_jobPSet.getAttrib (Job.FIELD_JobType))).listEntry (HELPER_ReferenceNumber.getForSQL(dummyReferenceNumber, tl_jobPSet.getAttrib (Job.FIELD_ReferenceNumber))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_Level)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_SecUser)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_job WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_job", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (JobPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_job");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_job for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (JobPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_jobPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (JobPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job");
        

        LogMgr.log (JobPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_jobPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_jobPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_job " +
                                                       "WHERE tl_job.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_job WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_job");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_job for row:" + objectID;

                    LogMgr.log (JobPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_jobPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    public ResultSet executeSearchQueryJobKey (SQLManager sqlMgr, Long ID, String Key) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryJobKey");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Job> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Job.REFERENCE_Job.getObjectIDSpace (), r.getLong ("id"));
            Job resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Job.REFERENCE_Job);

                if (cachedElement instanceof Job)
                {
                    LogMgr.log (JobPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Job)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Job");
                }
            }
            else
            {
                PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Job ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (JobPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_job " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (Job.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_job.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_job.object_id is not null
                    String preFilter = "(tl_job.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_job " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (Job.SEARCH_JobKey))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_job.object_id is not null
                    String preFilter = "(tl_job.object_id is not null)"
                                     + "  ";
                    
                        if (criteria.containsKey("ID"))
                        {
                            preFilter += " AND (object_id = ${ID} ) ";
                            preFilter += "";
                            
                        }
                    
                        if (criteria.containsKey("Key"))
                        {
                            preFilter += " AND (random_key = ${Key}) ";
                            preFilter += "";
                            
                        }
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_job " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_jobPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_jobPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_jobPSet.setAttrib(Job.FIELD_JobTitle, HELPER_JobTitle.getFromRS(dummyJobTitle, r, "job_title"));
        tl_jobPSet.setAttrib(Job.FIELD_JobDescription, HELPER_JobDescription.getFromRS(dummyJobDescription, r, "job_description"));
        tl_jobPSet.setAttrib(Job.FIELD_JobStatus, HELPER_JobStatus.getFromRS(dummyJobStatus, r, "job_status"));
        tl_jobPSet.setAttrib(Job.FIELD_OpenDate, HELPER_OpenDate.getFromRS(dummyOpenDate, r, "open_date"));
        tl_jobPSet.setAttrib(Job.FIELD_ApplyBy, HELPER_ApplyBy.getFromRS(dummyApplyBy, r, "apply_by"));
        tl_jobPSet.setAttrib(Job.FIELD_IncludeAssessmentCriteria, HELPER_IncludeAssessmentCriteria.getFromRS(dummyIncludeAssessmentCriteria, r, "include_assessment_criteria"));
        tl_jobPSet.setAttrib(Job.FIELD_AssessmentType, HELPER_AssessmentType.getFromRS(dummyAssessmentType, r, "assessment_type"));
        tl_jobPSet.setAttrib(Job.FIELD_RandomKey, HELPER_RandomKey.getFromRS(dummyRandomKey, r, "random_key"));
        tl_jobPSet.setAttrib(Job.FIELD_JobType, HELPER_JobType.getFromRS(dummyJobType, r, "job_type"));
        tl_jobPSet.setAttrib(Job.FIELD_ReferenceNumber, HELPER_ReferenceNumber.getFromRS(dummyReferenceNumber, r, "ref_number"));
        
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_Level, r.getObject ("level_id"));
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_SecUser, r.getObject ("secuser_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job");
        

        
        if (tl_jobPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_jobPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_job " +
                                     "  (job_title, job_description, job_status, open_date, apply_by, include_assessment_criteria, assessment_type, random_key, job_type, ref_number,  level_id, secuser_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_JobTitle.getForSQL(dummyJobTitle, tl_jobPSet.getAttrib (Job.FIELD_JobTitle))).listEntry (HELPER_JobDescription.getForSQL(dummyJobDescription, tl_jobPSet.getAttrib (Job.FIELD_JobDescription))).listEntry (HELPER_JobStatus.getForSQL(dummyJobStatus, tl_jobPSet.getAttrib (Job.FIELD_JobStatus))).listEntry (HELPER_OpenDate.getForSQL(dummyOpenDate, tl_jobPSet.getAttrib (Job.FIELD_OpenDate))).listEntry (HELPER_ApplyBy.getForSQL(dummyApplyBy, tl_jobPSet.getAttrib (Job.FIELD_ApplyBy))).listEntry (HELPER_IncludeAssessmentCriteria.getForSQL(dummyIncludeAssessmentCriteria, tl_jobPSet.getAttrib (Job.FIELD_IncludeAssessmentCriteria))).listEntry (HELPER_AssessmentType.getForSQL(dummyAssessmentType, tl_jobPSet.getAttrib (Job.FIELD_AssessmentType))).listEntry (HELPER_RandomKey.getForSQL(dummyRandomKey, tl_jobPSet.getAttrib (Job.FIELD_RandomKey))).listEntry (HELPER_JobType.getForSQL(dummyJobType, tl_jobPSet.getAttrib (Job.FIELD_JobType))).listEntry (HELPER_ReferenceNumber.getForSQL(dummyReferenceNumber, tl_jobPSet.getAttrib (Job.FIELD_ReferenceNumber))) .listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_Level)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_SecUser)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_jobPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
