import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class AssessmentService {

  constructor(
      private utilsService: UtilsService,
      private searchService: SearchService
  ) { }

  getWorkStyle(assocs = []): Observable<any> {
      return this.searchService.getObjects('WorkStyle', 'All', '', assocs, null, null, null, null)
          .map(
              data => {
                  return this.utilsService.convertResponseToObjects(data, assocs);
              }
          )
  }

  getWorkPreferences(assocs = []): Observable<any> {
      return this.searchService.getObjects('WorkPreferences', 'All', '', assocs, null, null, null, null)
          .map(
              data => {
                  return this.utilsService.convertResponseToObjects(data, assocs);
              }
          )
  }

    getDiversityProfile(assocs = []): Observable<any> {
        return this.searchService.getObjects('DiversityProfile', 'All', '', assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            )
    }

  saveWorkStyle(params): Observable<any> {
      return this.utilsService.processObjects('SaveWorkStyle', params);
  }

    saveWorkPreferences(params): Observable<any> {
        return this.utilsService.processObjects('SaveWorkPreferences', params);
    }

    saveDiversityProfile(params): Observable<any> {
        return this.utilsService.processObjects('SaveDiversityProfile', params);
    }


}
