<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="inc/stdimports.jsp" %>
<%@ include file="/editor/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "editMessageTemplate_jsp"; } %>
<%
    ORMProcessState     process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran         =   process.getTransaction ();
    boolean             toRedirect      =   GenericObjDF.getOrCreateObject (request, "MessageTemplate", MessageTemplate.REFERENCE_MessageTemplate);
    MessageTemplate     messageTemplate =   (MessageTemplate) process.getAttribute("MessageTemplate");
    
    if (toRedirect)
    {
        %><%@include file="/saferedirect.jsp"%><%
    }
    
    if (toRedirect)
    {
        %><%@include file="/saferedirect.jsp"%><%
    }
    
    Debug.assertion(messageTemplate != null, "MessageTemplate is null in Edit Message Template", "404");
    
    String  continuePage    =   "editMessageTemplate.jsp?MessageTemplateID=" + messageTemplate.getObjectID();

    request.setAttribute("oneit.pageFormDetails", CollectionUtils.mapEntry("name", "MessageTemplate").mapEntry("enctype", "multipart/form-data").toMap());
    request.setAttribute("oneit.pageHeaderTitle", "Message Template");
%>

<%@include file="/editor/header.jsp" %>

<script>
    
    function insertAtCaret(myValue) {
        myValue = myValue.trim();
        id  =   $("textarea").attr("id");
        CKEDITOR.instances[id].insertText(myValue);
    };

</script>

<style>
    textarea[id^=MessageContent] {
        width:70%;
    }
</style>

<oneit:layout_total widths="<%= new double[] {2, 3, 7} %>" skin="bootstrap">

    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormlabel obj="<%= messageTemplate %>"    field="Subject"/>
        </oneit:layout_label>
        <oneit:layout_field width="1">
            <oneit:ormInput obj="<%= messageTemplate %>"    attributeName="Subject" style="width:90%"    />
        </oneit:layout_field>
    </oneit:skin>

    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormlabel obj="<%= messageTemplate %>"    field="ApplicationStatus"/>
        </oneit:layout_label>
        <oneit:layout_field width="1">
            <oneit:ormEnum  obj="<%= messageTemplate %>"    attributeName="ApplicationStatus"    />
        </oneit:layout_field>
    </oneit:skin>

    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormlabel   obj="<%= messageTemplate %>"  field="DelayHrs"/>
        </oneit:layout_label>
        <oneit:layout_field width="1">
            <oneit:ormInput obj="<%= messageTemplate %>"    attributeName="DelayHrs"       style="width:30%" /><span>Hours</span> &nbsp;
            <oneit:ormInput obj="<%= messageTemplate %>"    attributeName="DelayMin"       style="width:30%" /><span>Mins</span>
        </oneit:layout_field>
    </oneit:skin>

    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormlabel   obj="<%= messageTemplate %>"  field="Variance"/>
        </oneit:layout_label>
        <oneit:layout_field width="1">
            <oneit:ormInput obj="<%= messageTemplate %>"    attributeName="Variance"    style="width:30%"    /><span>Mins</span>
        </oneit:layout_field>
    </oneit:skin>

    <oneit:skin tagName="layout_row">
        <oneit:layout_field width="1">
            <oneit:ormlabel   obj="<%= messageTemplate %>"  field=""/>
        </oneit:layout_field>
        <oneit:layout_field width="1">
            <oneit:ormInput type="checkbox" obj="<%= messageTemplate %>"    attributeName="BusinessHoursOnly"    /><span>Business Hours Only</span> 
        </oneit:layout_field>
    </oneit:skin>

    
    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1"><oneit:ormlabel   obj="<%= messageTemplate %>"    field="PlaceholderVariable"/></oneit:layout_label>
        <oneit:layout_field width="1">
            <oneit:skin tagName="button_group">

                <oneit:skin tagName="button_dropdown" label="Placeholder Variable" class="btn btn-default">

                    <li><oneit:button   value="First Name"      cssClass=" "    name="firstName"    skin="link" onClick="insertAtCaret('$firstName')" /></li>
                    <li><oneit:button   value="Surname"         cssClass=" "    name="surname"      skin="link" onClick="insertAtCaret('$surname')" /></li>
                    <li><oneit:button   value="Email Address"   cssClass=" "    name="emailAddress" skin="link" onClick="insertAtCaret('$emailAddress')" /></li>
                    <li><oneit:button   value="Location"        cssClass=" "    name="location"     skin="link" onClick="insertAtCaret('$location')" /></li>
                    <li><oneit:button   value="Job Title"       cssClass=" "    name="jobTitle"     skin="link" onClick="insertAtCaret('$jobTitle')" /></li>
                    <li><oneit:button   value="Job Reference"   cssClass=" "    name="jobReference" skin="link" onClick="insertAtCaret('$jobReference')" /></li>

                </oneit:skin>
            </oneit:skin>
        </oneit:layout_field>
    </oneit:skin>

    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1"></oneit:layout_label>
    </oneit:skin>
                    
    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormlabel     obj="<%= messageTemplate %>"    field="MessageContent"/>
        </oneit:layout_label>
        <oneit:layout_field width="2">
            <tagfile:htmleditor obj="<%= messageTemplate %>"    attribName="MessageContent" id="texteditor"/> 
        </oneit:layout_field>
    </oneit:skin>

</oneit:layout_total>
<div    class="bottomButtons"   hidden="true">

    <oneit:button   value="Save"            name="save" cssClass="BUTTON_PRIMARY"           
                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "listMessageTemplate.jsp").toMap() %>"/>
                                    
    <oneit:button   value="Cancel"          name="cancel"   cssClass="BUTTON_SECONDARY"     showIfReadOnly="true"
                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "listMessageTemplate.jsp")
                                                    .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                    .toMap() %>"/>
</div>

<%@include file="/editor/footer.jsp" %>