<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         =   (Job) process.getAttribute("Job");
    String  nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.JOB_PAYMENT);
    String  firstPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATE_JOB);
    String  secondPage  =   WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA);
    String  thirdPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.WORKPLACE_CULTURE);

    String  fifthPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.JOB_REVIEW);
    String  jobsPage    =   WebUtils.getSamePageInRenderMode(request, "Page");

    Article companyArticle  =   WebUtils.getArticleByShortCut(transaction, WebUtils.MY_COMPANY);
    String  billingPage     =   companyArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.BILLING).toMap());
    String  planPage        =   companyArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.MANAGE_PLAN).toMap());
    String  sharingPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATED_JOB) + "&fromJob=true";

    if(job == null && request.getParameter("JobID")!= null)
    {
       job  =  Job.getJobByID(transaction, Long.parseLong(request.getParameter("JobID")));
       
       process.setAttribute("Job", job);
    }
    
    CompanyUser     companyUser     =   job.getCreatedBy();
    Company         company         =   companyUser.getCompany();

    Debug.assertion(job != null, "Job is null in admin portal create job");

    HiringTeam  hiringTeam      =   job.getHiringTeam();
    HiringTeam  billingTeam     =   hiringTeam.getManageOwnBilling() ? hiringTeam : hiringTeam.getBilledByTeam();

    process.setAttribute("HiringTeam", billingTeam);
%>
    <oneit:form name="editJob" method="post" enctype="multipart/form-data">

        <div class="container-fluid">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

            
            <h1 class="page-title">Review Job
            <%
                if(billingTeam.getPaymentPlan() != null)
                {
                    Integer activeCount =   billingTeam.getUsedCredits();
                    Integer totCount    =   billingTeam.getAvailableCredits();
                    Integer remCount    =   (totCount - activeCount) > 0 ? (totCount - activeCount) : 0; 
            %>
                    <div style="float:right;">
                        <span class="pull-right plan-link">
                            <oneit:toString value="<%= remCount %>"    mode="EscapeHTML" />
                            /
                            <oneit:toString value="<%= totCount %>"    mode="EscapeHTML" />
                            &nbsp;Jobs remaining this month
                        </span>
                    </div>
            <%
                }
            %>
            </h1>
            
            <div class="form-page-area nopadding">
                <div class="create-job">
                  <div class="form-page-section">
                    <div class="form-group">
                        <label class="label-16 blue-label">Job Details</label>
                        <oneit:button   value="EDIT"   name="gotoPage" cssClass="add-more-btn review-edit-btn pull-right"   skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", firstPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .toMap() %>"/>
                    </div>       
                    
                    <div class="form-brack-line-sub"></div>

                    <div class="form-group row">
                        <div class="col-md-6 review-medium-title">
                            <oneit:label GUIName="Job Title" />
                            <span class="skill-label">
                                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                            </span>
                        </div>
                        <div class="col-md-6 review-medium-title">
                            <oneit:label GUIName="Reference Number" />
                            <span class="skill-label">
                                <oneit:toString value="<%= job.getReferenceNumber() %>"    mode="EscapeHTML" />
                            </span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12 review-medium-title">
                            <oneit:label GUIName="Job Description" />
                            <span class="skill-label">
                                <oneit:toString value="<%= job.getJobDescription() %>"  mode="ParagraphHTML" />
                            </span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-6 review-medium-title">
                            <oneit:label GUIName="Job Owner" />
                            <span class="skill-label">
                                <oneit:toString value="<%= job.getJobOwner() %>"    mode="EscapeHTML" />
                            </span>
                        </div>
                        <%
                            if(hiringTeam.showHasClientSupport())
                            {
                        %>
                                <div class="col-md-6 review-medium-title">
                                    <oneit:label GUIName="Client" />
                                    <span class="skill-label">
                                        <oneit:toString value="<%= job.getClient() %>"    mode="EscapeHTML" />
                                    </span>
                                </div>
                        <%
                            }
                        %>
                    </div>
                                        
                    <div class="form-brack-line-sub"></div>
                    <div class="form-group job-detail-subsection">
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Location" />
                            </div>
                            <div class="col-md-8">
                                <span class="skill-label">
                                    <oneit:toString value="<%= job.getGoogleAddressText() %>"  mode="EscapeHTML" />
                                </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Expected Candidate Radius" />
                            </div>
                            <div class="col-md-8">
                                <span class="skill-label">
                                    <oneit:toString value="<%= job.getExpectedCandidateRadius() != null ? job.getExpectedCandidateRadius().getDescription() : "" %>"  mode="ParagraphHTML" />
                                </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Working remote is an option" />
                            </div>
                            <div class="col-md-8">
                                <span class="skill-label">
                                    <oneit:toString value="<%= job.getRemote() ? "Yes" : "No" %>"  mode="EscapeHTML" />
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="form-brack-line-sub"></div>
                    <div class="form-group job-detail-subsection">
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Job Type" />
                            </div>
                            <div class="col-md-8">
                                <span class="skill-label">
                                    <oneit:toString value="<%= job.getJobType() != null ? job.getJobType().getDescription() : "" %>"  mode="EscapeHTML" />
                                </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Industry Classification" />
                            </div>
                            <div class="col-md-8">
                                <span class="skill-label">
                                    <oneit:toString value="<%= job.getIndustry() != null ? job.getIndustry().getDescription() : "" %>"  mode="EscapeHTML" />
                                </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Job Occupation Classification" />
                            </div>
                            <div class="col-md-8">
                                <span class="skill-label">
                                    <oneit:toString value="<%= job.getOccupation()%>"  mode="EscapeHTML"    nullValue="" />
                                </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Require CV & Cover Letter" />
                            </div>
                            <div class="col-md-8">
                                <span class="skill-label">
                                    <oneit:toString value="<%= job.getRequireCV() ? "Yes" : "No" %>"  mode="EscapeHTML" />
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="form-brack-line-sub"></div>
                    <div class="form-group job-detail-subsection">
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Role Assessment Type" />
                            </div>
                            <div class="col-md-8">
                                <span class="skill-label">
                                    <oneit:toString value="<%= job.getAssessmentType().getTestDescr() %>" mode="EscapeHTML"/> <oneit:toString value="<%= job.getAssessmentType().getQuestionDetails() %>" mode="EscapeHTML"/> 
                                </span>
                            </div>
                        </div>  
                    </div>          
                    <div class="form-brack-line-sub"></div>
                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-4 review-medium-title">
                                <oneit:label GUIName="Appllicant Workflow / Tabs" />
                            </div>
                            <div class="col-md-8 workflow-tabs">
                                <%
                                    for (WorkFlow workflow : job.getSortedWorkFlows())
                                    {
                                %>
                                        <span class="skill-label">
                                            <strong><%= workflow.getSortOrder()%> .</strong>&nbsp;&nbsp; <%= workflow.getName()%>
                                        </span>
                                <%
                                    }
                                %>
                            </div>
                        </div>  
                    </div>
                  </div>
                <div class="form-page-section darkbg">
                   
                    
                    <div class="form-group">
                        <label class="label-16 blue-label">Requirements</label>
                        <oneit:button   value="EDIT"   name="gotoPage" cssClass="add-more-btn review-edit-btn pull-right"   skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", secondPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .toMap() %>"/>
                    </div>
                    
                    
                    <%
                        for(CriteriaType criteria : CriteriaType.getCriteriaTypeArray())
                        {
                            Collection<AssessmentCriteria>  assessmentCriterias =   job.getAssessmentCriteraByType(criteria);

                            if(assessmentCriterias.size() == 0)
                            {
                                continue;
                            }
                    %>
                            <div class="form-brack-line-sub"></div>
                            <div class="form-group">
                                <div class="beloning">
                                    <oneit:toString value="<%= criteria.getDescription() %>" mode="EscapeHTML"/>
                                </div>
                            </div>
                    <%
                            for (AssessmentCriteria assessmentCriteria : assessmentCriterias)
                            {
                    %>
                            <div class="form-group row <%= assessmentCriteria.getImportance() == Importance.ESSENTIAL ? "essential" : "" %>">
                                <div class="col-md-5 review-medium-title">
                                    <oneit:toString value="<%= assessmentCriteria.getName() %>" mode="EscapeHTML"/>
                                </div>
                                <div class="col-md-2 assescriteria_importace" >
                                    <oneit:toString value="<%= assessmentCriteria.getImportance() %>" mode="EscapeHTML"/>
                                </div>
                                <div class="col-md-5 essential_note"  >
                                    <oneit:toString value="<%= assessmentCriteria.getImportance() == Importance.ESSENTIAL ? "This field will be mandatory for applicants" : "" %>"  mode="EscapeHTML" />
                                </div>
                            </div>
                    <%      }  
                        }   
                    %>
                </div>
                 <div class="form-page-section">
                    <div class="form-group">
                        <label class="label-16 blue-label">Culture</label>
                        <oneit:button   value="EDIT"   name="gotoPage" cssClass="add-more-btn review-edit-btn pull-right"   skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", thirdPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .toMap() %>"/>
                    </div>
                                                
                    <div class="form-brack-line-sub"></div>
                    
                    <div class="row">
                        <div class="col-md-12 review-medium-title">
                            <oneit:label GUIName="Organisation Culture Statement" />
                            <span class="skill-label">
                                <oneit:toString value="<%= job.getCultureStatement() %>"  mode="ParagraphHTML" />
                            </span>
                        </div>
                    </div>
                    <div class=" job-detail-subsection">       
                    <%
                        for(CultureClass cultureClass : CultureClass.getCultureClassArray())
                        {
                    
                            boolean firstCulture    =   true;

                            for (CultureCriteria criteria : job.getCultureCriteriasForClass(cultureClass))
                            {
                                if(criteria.getIsApplicable())
                                {
                                    if(firstCulture)
                                    {
                                        firstCulture = false;
                        %>
                                        <div class="form-brack-line-sub"></div>
                                        
                                        <div class="form-group">
                                            <div class="beloning">
                                                <oneit:toString value="<%= cultureClass %>" mode="EscapeHTML"/>
                                            </div>
                                        </div>
                        <%          
                                    }
                        %>
                                    <div class="row">
                                        <div class="col-md-4 review-label culture-element">
                                            <oneit:toString value="<%= criteria.getCultureElement() %>" mode="EscapeHTML"/> 
                                        </div>
                                        <div class="col-md-8 review-data">
                                            <oneit:toString value="<%= criteria.getCultureElementRating()!= null ? criteria.getCultureElementRating().getDescription() : ""%>" mode="EscapeHTML"/> 
                                                (<oneit:toString value="<%= criteria.getImportance() %>" mode="EscapeHTML"/>)
                                        </div>
                                    </div>
                    <%  
                                }
                            }

                            firstCulture = true;
                        }   
                    %>
                            </div>
                    <div class="text-center">
                        <oneit:button   value="Save as Draft and go to your jobs"   name="saveJob"  cssClass="btn  btn-primary btn-gray largeBtn"   
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                                        .mapEntry("DraftLocation", DraftLocation.REVIEW)
                                                                        .mapEntry("JobStatus", JobStatus.DRAFT)
                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                        .mapEntry ("attribNamesToRestore", Collections.singleton("Job"))
                                                                        .toMap() %>" />
                        
                    <%
                        if(billingTeam.getCardID() == null)
                        {
                    %>    
                            <oneit:button   value="Open this Job"   name="saveJob"  cssClass="btn btn-primary btn-green top-margin-25 largeBtn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", billingPage)
                                                                                .mapEntry("JobStatus", JobStatus.DRAFT)
                                                                                .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                .mapEntry ("attribNamesToRestore", new HashSet<String> (Arrays.asList(new String[] {"Job", "HiringTeam"})))
                                                                                .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                .toMap() %>" />
                    <%
                        }
                        else if(billingTeam.canCreateJob())
                        {
                    %>    
                            <oneit:button   value="Open this Job"   name="saveJob"  cssClass="btn btn-primary btn-green top-margin-25 largeBtn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", sharingPage)
                                                                                .mapEntry("JobStatus", JobStatus.OPEN)
                                                                                .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                .mapEntry ("attribNamesToRestore", Collections.singleton("Job"))
                                                                                .toMap() %>" />
                    <%
                        }
                        else if(billingTeam.isTrue(billingTeam.getIsPPJ()))
                        {
                    %>    
                            <oneit:button   value="Open this Job"   name="savePayment"  cssClass="btn btn-primary btn-green top-margin-25 largeBtn"
                                              requestAttribs="<%= CollectionUtils.mapEntry("nextPage", sharingPage)
                                                                                .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                .mapEntry ("attribNamesToRestore", Collections.singleton("Job"))
                                                                                .toMap() %>" />
                    <%
                        }
                        else
                        {
                    %>    
                            <oneit:button   value="Open this Job"   name="saveJob"  cssClass="btn btn-primary btn-green top-margin-25 largeBtn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", planPage)
                                                                                .mapEntry("JobStatus", JobStatus.DRAFT)
                                                                                .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                .mapEntry ("attribNamesToRestore", new HashSet<String> (Arrays.asList(new String[] {"Job", "HiringTeam"})))
                                                                                .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                .toMap() %>" />
                    <%
                        }
                    %>
                    </div>
                  </div>
                </div>
            </div>
        </div>    
    </oneit:form>
</oneit:dynIncluded>