package performa.search;

import oneit.objstore.BaseBusinessClass;
import oneit.objstore.rdbms.filters.EqualsFilter;
import performa.orm.BaseJob;
import performa.orm.Job;
import performa.orm.types.JobStatus;


public class SearchHome extends BaseSearchHome
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public SearchHome ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
     @Override
    public BaseBusinessClass[] doSearch() 
    {
        BaseJob.SearchAll   search  =   Job.SearchByAll()
                                            .andHiringTeam(new EqualsFilter<>(getHiringTeam()))
                                            .andJobStatus(new EqualsFilter<>(JobStatus.OPEN));
        
        if(!getShowAllJobs())
        {
            search  =   search.andJobOwner(new EqualsFilter<>(getCompanyUser()));
        }
        
        return  search.search(getTransaction());
    }
}