
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class CandidateClassScorePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea CandidateClassScorePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "CandidateClassScore");

    // Private attributes corresponding to business object data
    private Integer dummyClassScore;
    private Integer dummyWghtdClassScore;
    private Integer dummyMaxWghtdClassScore;
    private ColorCode dummyColorCode;
    private ColorCode dummyWghtdColorCode;
    private FactorClass dummyFactorClass;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_ClassScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_WghtdClassScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_MaxWghtdClassScore = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_ColorCode = new EnumeratedAttributeHelper (ColorCode.FACTORY_ColorCode);
    private static final EnumeratedAttributeHelper HELPER_WghtdColorCode = new EnumeratedAttributeHelper (ColorCode.FACTORY_ColorCode);
    private static final EnumeratedAttributeHelper HELPER_FactorClass = new EnumeratedAttributeHelper (FactorClass.FACTORY_FactorClass);
    



    public CandidateClassScorePersistenceMgr ()
    {
        dummyClassScore = (Integer)(HELPER_ClassScore.initialise (dummyClassScore));
        dummyWghtdClassScore = (Integer)(HELPER_WghtdClassScore.initialise (dummyWghtdClassScore));
        dummyMaxWghtdClassScore = (Integer)(HELPER_MaxWghtdClassScore.initialise (dummyMaxWghtdClassScore));
        dummyColorCode = (ColorCode)(HELPER_ColorCode.initialise (dummyColorCode));
        dummyWghtdColorCode = (ColorCode)(HELPER_WghtdColorCode.initialise (dummyWghtdColorCode));
        dummyFactorClass = (FactorClass)(HELPER_FactorClass.initialise (dummyFactorClass));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_candidate_class_score.object_id as id, {PREFIX}tl_candidate_class_score.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_candidate_class_score.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_candidate_class_score.class_score, {PREFIX}tl_candidate_class_score.wghtd_class_score, {PREFIX}tl_candidate_class_score.max_wghtd_class_score, {PREFIX}tl_candidate_class_score.color_code, {PREFIX}tl_candidate_class_score.wghtd_color_code, {PREFIX}tl_candidate_class_score.factor_class, {PREFIX}tl_candidate_class_score.test_analysis_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, CandidateClassScore.REFERENCE_CandidateClassScore);

                if (objectToReturn instanceof CandidateClassScore)
                {
                    LogMgr.log (CandidateClassScorePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a CandidateClassScore");
                }
            }

            PersistentSet tl_candidate_class_scorePSet = allPSets.getPersistentSet(id, "tl_candidate_class_score", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_candidate_class_scorePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_candidate_class_scorePSet.containsAttrib(CandidateClassScore.FIELD_ClassScore)||
                    !tl_candidate_class_scorePSet.containsAttrib(CandidateClassScore.FIELD_WghtdClassScore)||
                    !tl_candidate_class_scorePSet.containsAttrib(CandidateClassScore.FIELD_MaxWghtdClassScore)||
                    !tl_candidate_class_scorePSet.containsAttrib(CandidateClassScore.FIELD_ColorCode)||
                    !tl_candidate_class_scorePSet.containsAttrib(CandidateClassScore.FIELD_WghtdColorCode)||
                    !tl_candidate_class_scorePSet.containsAttrib(CandidateClassScore.FIELD_FactorClass)||
                    !tl_candidate_class_scorePSet.containsAttrib(CandidateClassScore.SINGLEREFERENCE_TestAnalysis))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (CandidateClassScorePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                CandidateClassScore result = new CandidateClassScore ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_candidate_class_score " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_candidate_class_score.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (CandidateClassScore.SINGLEREFERENCE_TestAnalysis))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_candidate_class_score " +
                            "WHERE " + SELECT_JOINS + "test_analysis_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_candidate_class_scorePSet = allPSets.getPersistentSet(objectID, "tl_candidate_class_score");
            

            
            if (tl_candidate_class_scorePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_candidate_class_scorePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_candidate_class_score " +
                                                           "SET class_score = ?, wghtd_class_score = ?, max_wghtd_class_score = ?, color_code = ?, wghtd_color_code = ?, factor_class = ?, test_analysis_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_candidate_class_score.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_ClassScore.getForSQL(dummyClassScore, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_ClassScore))).listEntry (HELPER_WghtdClassScore.getForSQL(dummyWghtdClassScore, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_WghtdClassScore))).listEntry (HELPER_MaxWghtdClassScore.getForSQL(dummyMaxWghtdClassScore, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_MaxWghtdClassScore))).listEntry (HELPER_ColorCode.getForSQL(dummyColorCode, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_ColorCode))).listEntry (HELPER_WghtdColorCode.getForSQL(dummyWghtdColorCode, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_WghtdColorCode))).listEntry (HELPER_FactorClass.getForSQL(dummyFactorClass, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_FactorClass))).listEntry (SQLManager.CheckNull((Long)(tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.SINGLEREFERENCE_TestAnalysis)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_candidate_class_score WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_candidate_class_score", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (CandidateClassScorePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_candidate_class_score");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_candidate_class_score for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (CandidateClassScorePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_candidate_class_scorePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (CandidateClassScorePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_candidate_class_scorePSet = allPSets.getPersistentSet(objectID, "tl_candidate_class_score");
        

        LogMgr.log (CandidateClassScorePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_candidate_class_scorePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_candidate_class_scorePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_candidate_class_score " +
                                                       "WHERE tl_candidate_class_score.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_candidate_class_score WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_candidate_class_score");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_candidate_class_score for row:" + objectID;

                    LogMgr.log (CandidateClassScorePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_candidate_class_scorePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, CandidateClassScore> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (CandidateClassScore.REFERENCE_CandidateClassScore.getObjectIDSpace (), r.getLong ("id"));
            CandidateClassScore resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, CandidateClassScore.REFERENCE_CandidateClassScore);

                if (cachedElement instanceof CandidateClassScore)
                {
                    LogMgr.log (CandidateClassScorePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (CandidateClassScore)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a CandidateClassScore");
                }
            }
            else
            {
                PersistentSet tl_candidate_class_scorePSet = allPSets.getPersistentSet(objectID, "tl_candidate_class_score", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new CandidateClassScore ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (CandidateClassScorePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_candidate_class_score " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (CandidateClassScore.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_level_factor.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_level_factor.object_id is not null
                    String preFilter = "(tl_level_factor.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_candidate_class_score " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_candidate_class_scorePSet = allPSets.getPersistentSet(objectID, "tl_candidate_class_score", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_candidate_class_scorePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_candidate_class_scorePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_candidate_class_scorePSet.setAttrib(CandidateClassScore.FIELD_ClassScore, HELPER_ClassScore.getFromRS(dummyClassScore, r, "class_score"));
        tl_candidate_class_scorePSet.setAttrib(CandidateClassScore.FIELD_WghtdClassScore, HELPER_WghtdClassScore.getFromRS(dummyWghtdClassScore, r, "wghtd_class_score"));
        tl_candidate_class_scorePSet.setAttrib(CandidateClassScore.FIELD_MaxWghtdClassScore, HELPER_MaxWghtdClassScore.getFromRS(dummyMaxWghtdClassScore, r, "max_wghtd_class_score"));
        tl_candidate_class_scorePSet.setAttrib(CandidateClassScore.FIELD_ColorCode, HELPER_ColorCode.getFromRS(dummyColorCode, r, "color_code"));
        tl_candidate_class_scorePSet.setAttrib(CandidateClassScore.FIELD_WghtdColorCode, HELPER_WghtdColorCode.getFromRS(dummyWghtdColorCode, r, "wghtd_color_code"));
        tl_candidate_class_scorePSet.setAttrib(CandidateClassScore.FIELD_FactorClass, HELPER_FactorClass.getFromRS(dummyFactorClass, r, "factor_class"));
        
        tl_candidate_class_scorePSet.setAttrib(CandidateClassScore.SINGLEREFERENCE_TestAnalysis, r.getObject ("test_analysis_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_candidate_class_scorePSet = allPSets.getPersistentSet(objectID, "tl_candidate_class_score");
        

        
        if (tl_candidate_class_scorePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_candidate_class_scorePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_candidate_class_score " +
                                     "  (class_score, wghtd_class_score, max_wghtd_class_score, color_code, wghtd_color_code, factor_class,  test_analysis_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_ClassScore.getForSQL(dummyClassScore, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_ClassScore))).listEntry (HELPER_WghtdClassScore.getForSQL(dummyWghtdClassScore, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_WghtdClassScore))).listEntry (HELPER_MaxWghtdClassScore.getForSQL(dummyMaxWghtdClassScore, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_MaxWghtdClassScore))).listEntry (HELPER_ColorCode.getForSQL(dummyColorCode, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_ColorCode))).listEntry (HELPER_WghtdColorCode.getForSQL(dummyWghtdColorCode, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_WghtdColorCode))).listEntry (HELPER_FactorClass.getForSQL(dummyFactorClass, tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.FIELD_FactorClass))) .listEntry (SQLManager.CheckNull((Long)(tl_candidate_class_scorePSet.getAttrib (CandidateClassScore.SINGLEREFERENCE_TestAnalysis)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_candidate_class_scorePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
