/**
 * Reference : https://stripe.com/docs/stripe-js#elements
 */

// Create a Stripe client
var stripe = Stripe(stripePubKey);

// Create an instance of Elements
var elements = stripe.elements();

// Custom styling can be passed to options when creating an Element.
var style = {
  base: {
    // Add your base input styles here. For example:
    fontSize: '16px',
    color: "#32325d",
  }
};

var cardNumber = elements.create('cardNumber', {style: style});
cardNumber.mount('#card-number');

var cardExpiry = elements.create('cardExpiry', {style: style});
cardExpiry.mount('#card-expiry');

var cardCvc = elements.create('cardCvc', {style: style});
cardCvc.mount('#card-cvc');
  
// Create an instance of the card Element
//var card = elements.create('card', {style: style});

// Add an instance of the card Element into the `card-element` <div>
//card.mount('#card-element');

//card.addEventListener('change', function(event) {
//  var displayError = document.getElementById('card-errors');
//  if (event.error) {
//    displayError.textContent = event.error.message;
//  } else {
//    displayError.textContent = '';
//  }
//});
cardNumber.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});
cardExpiry.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});
cardCvc.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});

// Create a token or display an error when the form is submitted.
var form = document.getElementById('makePayment');

form.addEventListener('submit', function(event) {
    event.preventDefault();

    stripe.createToken(cardNumber, {name: "Demo Card Name"}).then(function(result) {
        if (result.error) {
            // Inform the customer that there was an error
            var errorElement = document.getElementById('card-errors');
            errorElement.textContent = result.error.message;
        } else {
            // Send the token to your server
            $('input[name=stripe-token-id]').val(result.token.id);
            $('#payNow').click();
      //      stripeTokenHandler(result.token);
        }
    });
});

function stripeTokenHandler(token) {
  // Insert the token ID into the form so it gets submitted to the server
//  var form = document.getElementById('payment-form');
//  var hiddenInput = document.createElement('input');
//  hiddenInput.setAttribute('type', 'hidden');
//  hiddenInput.setAttribute('name', 'stripeToken');
//  hiddenInput.setAttribute('value', token.id);
//  form.appendChild(hiddenInput);
alert(token.id);
    $('input[name=stripe-token-id]').val(token.id);
//    $('div.stripedetails').removeClass('stripedetails');
alert($('input[name=stripe-token-id]').val());
    $('#payNow').click();
  // Submit the form
//  form.submit();
}