package performa.form;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.filter.CollectionFilter;
import oneit.utils.filter.Filter;
import performa.orm.Job;
import performa.orm.JobApplication;
import performa.orm.types.AppProcessOption;
import performa.orm.types.ApplicationStatus;


public class BulkUpdateFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest      request         =   submission.getRequest();
        List<JobApplication>    applications    =   ObjstoreUtils.getActioned(request, "IsSelected", process.getTransaction(), JobApplication.REFERENCE_JobApplication);
        Job                     job             =   (Job) request.getAttribute("Job");

        LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING1,"In BulkUpdateFP selected application count : ", applications != null ? applications.size() : 0 , " of job ", job);

        if(job.getAppProcessOption() == AppProcessOption.TO_SHORTLIST && job.getNoOfCandidatesApplied() > job.getMaxShortlistApplicants() && applications != null)
        {
            Filter<JobApplication>  filter              =   JobApplication.SearchByAll().andApplicationStatus(new EqualsFilter<>(ApplicationStatus.SHORTLISTED));
            Collection              alreadyShortlisted  =   CollectionFilter.filter(applications, filter);
            int                     totalShortlisted    =   applications.size() - alreadyShortlisted.size() + job.getNoOfCandidatesShortlisted();
          
            BusinessObjectParser.assertFieldCondition(totalShortlisted <= job.getMaxShortlistApplicants() , job , Job.MULTIPLEREFERENCE_JobApplications, "exceedMaxShortlisted");
        }
        
        for(JobApplication application : applications)
        {
            if(job.getAppProcessOption() == AppProcessOption.TO_SHORTLIST)
            {
                application.setApplicationStatus(ApplicationStatus.SHORTLISTED);
            }
            else if(job.getAppProcessOption() == AppProcessOption.REMOVE_FROM_SHORTLIST)
            {
                application.setApplicationStatus(ApplicationStatus.SUBMITTED);
            }
            
            LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING1,"In BulkUpdateFP Job Application Status successfully changed : ", application );
        }
                    
        return super.processForm(process, submission, params);
    }
}
