<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils" %>

<oneit:dynIncluded>
<%
    String              currentPage     =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    ObjectTransaction   objTran         =   ObjectTransaction.getTransaction();
    Long                jobAppId        =   process.getAttribute("JobApplicationID") != null ? 
                                                (Long) process.getAttribute("JobApplicationID") :
                                                ((JobApplication) process.getAttribute("JobApplication")).getID().longValue();
    JobApplication      jobApplication  =   null;

    if(jobAppId != null)
    {
        jobApplication  =   JobApplication.getJobApplicationByID(objTran, jobAppId);
    }

    if(jobApplication == null)
    {
        jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    }

    Debug.assertion(jobApplication != null, "Job Application cannot be null in applicant  portal - job match assessment ");
      
    if(process.getAttribute("JobApplicationID") == null)
    {
        process.setAttribute("JobApplicationID" , jobApplication.getID().longValue());
    }

    //preloading
    jobApplication.pipelineJobApplication().toCandidate().toProfileAssessmentAnswers().toQuestion().toRightQuestion().uniqueVals();
    
    Job                 job             =   jobApplication.getJob();
    Candidate           candidate       =   jobApplication.getCandidate();
    int                 questionNumber  =   jobApplication.getQuestionNumber();
    int                 actualNumber    =   jobApplication.getActualQuestionNumber();
    List<Question>      totalQuestions  =   (List<Question>) process.getAttribute("TotalQuestions");
    List<Question>      allQuestions    =   (List<Question>) process.getAttribute("AllQuestions");
    String              exitPage        =   WebUtils.getArticleLink(request, transaction, WebUtils.APPLY_JOB, "Page") + "&id=" + job.getID() + "&key=" + job.getRandomKey();

    if(totalQuestions == null)
    {
        totalQuestions  =   job.getAllQuestions();
        
        process.setAttribute("TotalQuestions", totalQuestions);
    }

    if(allQuestions == null)
    {
        allQuestions    =   job.getAllLeftQuestions(totalQuestions);
        
        process.setAttribute("AllQuestions", allQuestions);
    }

    Question        question        =   (Question) allQuestions.get(questionNumber).getInTransaction (objTran);
    QuestionType    questionType    =   question.getQuestionType();
%>
    <script>
        $(document.body).addClass('bg-color');
        
        $(document).ready(function(){
            
            $(".answer_radio").change(function(){
                $(".ratting-number li.active").removeClass("active" );
                $(".ratting-number input[type='radio']:checked").closest('li').addClass("active" );
            });

            $('.timer').countimer({
                displayMode: 1,
                initMinutes: 0,
                minuteIndicator: ' min ago',
                leadingZeros: 0
            });
        });
        
        function gotoNextQuestion(questionNumber, actualNumber, completeApplication, answerNo)
        {
            $('.answer_radio').prop('disabled', true);
            $('.main-sc-section').css('opacity','0.6');
            var radioid = "#" + answerNo;
            
            $(radioid).closest('li').addClass(" active ");
            
            setTimeout(
                function() {
                    ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/applicantportal/inc/save_job_match_answers.jsp", 'form' , 
                        {questionNumber : questionNumber, answerNo: answerNo, actualNumber: actualNumber, completeApplication: completeApplication}, 
                        function () {}, 
                        function (jqXHR, textStatus, errorThrown) {
                            if (jqXHR.status == 0) {
                                log("Empty Response. Status : " + jqXHR.status);
                            } else {
                                window.alert("Error processing request:" + errorThrown);
                            }
                        }, 
                    "POST");

                    if(completeApplication)
                    {
                        $("#gotoPageNext").click();
                        return false;
                    }
                  
                    ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/applicantportal/inc/job_match_questions.jsp", '.job-match-questions' , {questionNumber : questionNumber, actualNumber: actualNumber},
                        function (theHTML_JQ) {
                            $( ".job-match-questions" ).after("<div class='job-match-questions'></div>"); //This will add a new element to the DOM
                            $('.job-match-questions:last').html(theHTML_JQ).hide(); // Add the new HTML to the newly created element and hide it
                            $(".job-match-questions:first").slideUp();
                            $(".job-match-questions:last").slideDown();
                            setTimeout(function(){
                              $(".job-match-questions:first").remove();
                            },800); 
                    }); 
                    
                    $('.timer').countimer('start');
                },
            500); // delay in order to visually reinforce selection before advancing
        }
    </script>
      <div class="apply-job-logo-header signinpage">
           <div>
               <div class="logo-img">
                       <%
                    BinaryContent   logo    =   job.getLogo();

                    if(logo != null)
                    {
                        int logoHeight  =   45;
                %>

                            <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />

                <%
                    }
                %>
               </div>
                  <div class="header-title">
            Austrilia Post
        </div>
           </div>
       </div>
    <div class="main-application-outline">
         <div class="job-title" ><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Your Work Style</div>
            <div class="mobile-estimated">Estimated time to complete: 
                <span class="estimated-time-20">&nbsp;20 mins</span>
            </div>
        </div>
        <div class="section-c-title m-hide">
            Your Work Style
            <span>Estimated time to complete: 
                <span class="estimated-time-20">&nbsp;20 mins</span>
            </span>
        </div>
        <div class="section-tab-view">
            
            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
            
                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"           data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="3"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area section-job-match">
                    <div class="job-match-questions">
                        <oneit:dynInclude   page="/extensions/applicantportal/inc/job_match_questions.jsp"  
                                            actualNumber="<%= actualNumber %>"
                                            questionNumber  ="<%= questionNumber %>"
                                            data="<%= CollectionUtils.EMPTY_MAP%>"/>
                    </div> 
                    <div class="job-match-buttons">
                        <div class="auto-save">
                            Autosaved <span class="timer"></span> 
                        </div> 
                        <div class="section-btn text-center">
                            <a href="<%= exitPage%>" class="btn box-btn-gray">Save and exit</a>
                        </div>
                    </div>
                </div>
            </oneit:form>
        </div>
</oneit:dynIncluded>