<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    boolean toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job     job         =   (Job) process.getAttribute("Job");
    String  jobPage     =   WebUtils.getSamePageInRenderMode(request, "Page");

    Debug.assertion(job != null, "Job is null in admin portal create job");
    
    if(toRedirect)
    {
        %><%@include file="/saferedirect.jsp" %><%
    }

    SecUser     txUser      =   SecUser.getTXUser(process.getTransaction());
    CompanyUser companyUser =   txUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    Job[]       jobs        =   Job.SearchByCompany().byCompany(companyUser.getCompany()).search(transaction);
    String      nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA);
    
    job.setHiringTeam(companyUser.getSelectedTeam());
    job.setJobOwner(companyUser);
%>
 


    <script type="text/javascript">
        $(document).ready(function() 
        {
            setupRecalc ($("form#editJob"), {'recalcOnError':true});

            $("select[name$='JobTemplate']").change(function()
            {
                $("button[name$='loadJobFromTemplate']").click();
            });
            
         
        });
    </script>    

    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
        <div class="container-fluid">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        
            <h1 class="page-title">Create a job</h1>

            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="1"    data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <%
                job.setCompletedDetails(Boolean.TRUE);
            %>
            <div class="form-page-area">
           <div class="create-job"> 
            <div class="form-page-section">
                
                <%
                    if(jobs.length > 0)
                    {
                %>
                        <oneit:button   value=" "   name="loadJobFromTemplate"  cssClass="hide"
                                        requestAttribs="<%= CollectionUtils.mapEntry ("Job", job)
                                                                        .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                        .toMap() %>" />

                        <div class="form-group wider-select">
                            <tagfile:ormsingleasso_select   obj="<%= job %>"    assocName="JobTemplate" options="<%= jobs %>"  
                                                            blankValue="Optional: Use another Job as a starting point"/>
                        </div>
                <%
                    }
                %>
                    <div class="form-group row">
                        <div class="col-md-8">
                            <label><oneit:label GUIName="Job Title" /></label>
                            <oneit:ormInput obj="<%= job %>"    type="text" attributeName="JobTitle"    cssClass="form-control" />                                
                        </div>
                        <div class="col-md-4">
                            <label><oneit:label GUIName="Reference Number" /><a href="#" title="Uniquely identify jobs that have identical titles. Examlple:<br>&#8226; New Home Sales Consutant (ABC123)<br>&#8226;  New Home Sales Consutant (ABC456)" class="info-icon"><img src="images/info-icon.png" /></a></label>
                            <oneit:ormInput obj="<%= job %>"    type="text" attributeName="ReferenceNumber" cssClass="form-control" />
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12">
                            <label><oneit:label GUIName="About the Job" /></label>
                            <oneit:ormtextarea  obj="<%= job %>"    attributeName="JobDescription"  cssClass="form-control textarea-box"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-6">
                            <label><oneit:label GUIName="Job Owner"/></label>
                            <div class="wider-select">
                                <tagfile:ormsingleasso_select obj="<%= job %>"  assocName="JobOwner"    options="<%= job.getHiringTeam().getActiveTeammates().toArray(new CompanyUser[0]) %>"/>
                            </div>
                        </div>
                        <%
                            if(job.getHiringTeam().showHasClientSupport())
                            {
                        %>
                                <div class="col-sm-6 col-xs-12">
                                    <label><oneit:label GUIName="Client "/><span>(Optional)</span></label>
                                    <div class="wider-select">
                                        <tagfile:ormsingleasso_select obj="<%= job %>"  assocName="Client"  options="<%= Utils.getClientsByHiringTeam(transaction) %>"/>
                                    </div> 
                                </div>
                        <%
                            }
                        %>
                    </div>
                    
                   </div>
               <div class="form-page-section darkbg">
                    
                    <div class="form-group row">
                        <div class="col-md-12">
                            <label class="label-16">Job Location</label>                
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-6">
                            <label><oneit:ormlabel  obj="<%= job %>"    field="Country" /></label>
                            <oneit:ormEnum  obj="<%= job %>"    attributeName="Country" cssClass="form-control"/>
                        </div>
                        <div class="col-md-6">
                            <label><oneit:label GUIName="State or Province"/></label>
                            <oneit:ormEnum  obj="<%= job %>"    attributeName="State" cssClass="form-control"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4">
                            <label><oneit:label GUIName="City or Town"/></label>
                            <oneit:ormInput obj="<%= job %>"    type="text" attributeName="City"        cssClass="form-control" />      
                        </div>
                        <div class="col-md-4">
                            <label><oneit:label GUIName="Zip / Post Code"/></label>
                            <oneit:ormInput obj="<%= job %>"    type="text" attributeName="PostCode"    cssClass="form-control" />      
                        </div>
                        <div class="col-md-4">
                            <label><oneit:label GUIName="Expected Candidate Radius"/></label>
                            <oneit:ormEnum  obj="<%= job %>"    attributeName="ExpectedCandidateRadius" cssClass="form-control"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4">
                            <div class="styled_checkboxes">
                                <div class="checkbox checkbox-primary">
                                    <oneit:ormInput obj="<%= job %>"  id="is-remote"    attributeName="Remote"  type="checkbox"/>
                                    <oneit:recalcClass  htmlTag="span"  classScript="job.getRemote() != null && job.getRemote() ? 'checked': 'unchecked'"    job="<%= job %>">
                                        <label for="is-remote">
                                            <oneit:label GUIName="Working remotely is an option" />
                                        </label>
                                    </oneit:recalcClass>
                                </div>
                            </div>
                        </div>
                    </div>
                                    
                  </div>
                <div class="form-page-section"> 

                    <div class="form-group row">
                        <div class="col-md-12">
                            <label><oneit:label GUIName="Job Type" /></label>
                            <oneit:ormEnum  obj="<%= job %>"    attributeName="JobType" cssClass="form-control"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-6">
                            <label><oneit:label GUIName="Industry Classification" /></label>
                            <oneit:ormEnum  obj="<%= job %>"    attributeName="Industry"    cssClass="form-control"/>
                        </div>
                        <div class="col-md-6">
                            <label><oneit:label GUIName="Job Occupation Classification" /></label>
                            <tagfile:ormsingleasso_select obj="<%= job %>"  assocName="Occupation"    options="<%= Occupation.searchAll(transaction) %>"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12">
                            <div class="styled_checkboxes">
                                <div class="checkbox checkbox-primary">
                                    <oneit:ormInput obj="<%= job %>"  id="require-cv"    attributeName="RequireCV"  type="checkbox"/>
                                    <oneit:recalcClass  htmlTag="span"  classScript="job.getRequireCV() != null && job.getRequireCV() ? 'checked': 'unchecked'"    job="<%= job %>">
                                        <label for="require-cv">
                                            <oneit:label GUIName="Require CV and Cover Letter from Candidate" />
                                        </label>
                                    </oneit:recalcClass>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12">
                            <label class="label-16">Select your assessment type</label>                
                        </div>
                    </div>
                <%
                    FormTag     jobForm             =   FormTag.getActiveFormTag(request);
                    FormBuilder formBuilder         =   jobForm.getFormBuilder();
                    String      assessmentTypeKey   =   WebUtils.getInputKey(request, job, Job.FIELD_AssessmentType);
                    String      assessmentTypeValue =   formBuilder.fieldValue (assessmentTypeKey, job.getAssessmentType() == null ? "" : job.getAssessmentType().getName());

                    for(AssessmentType assessmentType : AssessmentType.getAssessmentTypeArray())
                    {
                        String  assessmentTypeId    =   assessmentType.getName();
                        String  selectedStr         =   CollectionUtils.equals(assessmentTypeValue, assessmentTypeId) ? "checked" : "";

                        String  levelKey    =   WebUtils.getRadioSingleAssocKey(request, job, Job.SINGLEREFERENCE_Level);
                        String  levelValue  =   formBuilder.fieldValue (levelKey, job.getLevel() == null ? "" : String.valueOf(job.getLevelID()));

                %>
                        <div class="radio radio-primary job-match-radio">
                            <input type="radio" name="<%= assessmentTypeKey %>" id="<%= assessmentTypeId %>"    class="type_radio" value="<%= assessmentType.getName() %>" <%= selectedStr %>/>
                            <label for="<%= assessmentTypeId %>">
                                <span class="label-title"><oneit:toString value="<%= assessmentType %>" mode="EscapeHTML" /></span>
                                <oneit:toString value="<%= assessmentType.getQuestionDetails() %>"  mode="EscapeHTML"/><br />
                            </label>
                        </div>

                        <oneit:recalcClass  htmlTag="div"    classScript="job.getAssessmentType() == assessmentType ? 'main-pack-type' : '' "  job="<%= job %>"    assessmentType="<%= assessmentType %>">
                            <ul>
                            <%
                                for(Level level : Level.getAllLevelsforAssessmentType(transaction, assessmentType))
                                {
                                    String  levelId     =   String.valueOf(level.getID().longID());
                                    boolean isSelected  =   CollectionUtils.equals(levelId, levelValue);
                                    String  selected    =   isSelected ? "checked" : "";
                            %>
                                    <oneit:recalcClass  htmlTag="li"    classScript="job.getLevelClass(level)"  job="<%= job %>"    level="<%= level %>">
                                        <a href="javascript:void(0)">
                                            <input type="radio" name="<%= levelKey %>" id="<%= levelId %>"  class="level_radio" value="<%= levelId %>" <%= selected %>/>
                                            <label for="<%= levelId %>">
                                                <span class="talen">Talentology</span>
                                                <span class="pack-type"><oneit:toString value="<%= level %>"    mode="EscapeHTML" /></span>
                                                <span class="pack-img <%= level.getCSSClass() %>"></span>
                                            </label>
                                        </a>
                                    </oneit:recalcClass>
                            <%
                                }
                            %>
                            </ul>
                        </oneit:recalcClass>
                        <div class="clearfix"></div>           
                <%
                    }

                    String  levelKey    =   WebUtils.getRadioSingleAssocKey(request, job, Job.SINGLEREFERENCE_Level);
                    String  levelValue  =   formBuilder.fieldValue (levelKey, job.getLevel() == null ? "" : String.valueOf(job.getLevelID()));
                %>
              </div>
              <div class="form-page-section darkbg">
                    <div class="form-group row">
                        <div class="col-md-12">
                            <label class="label-16">Applicant Workflow</label>                
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12">
                            Please define your applicant approval/refinement workflow and tabs below. We have nominated some defaults to help you get started. You are allowed up to 9 different steps, and can drag to re-order using the handle on the left.
                        </div>
                    </div>
                    
                    <div class="form-brack-line"></div>
                    <div class="text-center">
                    <div class="form-group row">
                        <div class="col-md-12">
                            Job Templates include both Job Details and Requirements.
                        </div>
                        <div class="col-md-12">
                            Saving a new Job Template a can be completed on the next step.                        
                        </div>
                    </div>
                        <oneit:button   value="Save as draft"   name="saveJob"  cssClass="btn btn-primary largeBtn greyBtn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage)
                                                                            .mapEntry("DraftLocation", DraftLocation.DETAILS)
                                                                            .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                            .toMap() %>"/>
                        <oneit:button   value="Proceed to Requirements" name="processCulture" cssClass="btn btn-primary largeBtn" 
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                        .mapEntry("fromJobMatch", true)
                                                                        .toMap() %>"/>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>
