import { Component, OnInit, ViewChild } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { ActivatedRoute, Router } from '@angular/router';
import { takeUntil } from 'rxjs/operators';
import { PersonalDetailsComponent } from '../../mc-shared/personal-details/personal-details.component';
import { WorkHistoryComponent } from './work-history/work-history.component';
import { EducationComponent } from './education/education.component';
import { SkillsComponent } from './skills/skills.component';
import { ReferencesComponent } from './references/references.component';
import { CareerProfileModel } from '../../models/career-profile.model';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Component({
    selector: 'app-career-history',
    templateUrl: './career-history.component.html',
    styleUrls: ['./career-history.component.scss']
})
export class CareerHistoryComponent extends BaseComponent implements OnInit {

    tabs = ['templates', 'personal-data', 'work-history', 'education', 'skills', 'references', 'publish'];
    careerProfile: CareerProfileModel;
    activeTab = '';
    isExiting = false;

    @ViewChild('personalDetailsComponent') personalDetailsComponent: PersonalDetailsComponent;
    @ViewChild('workHistoryComponent') workHistoryComponent: WorkHistoryComponent;
    @ViewChild('educationComponent') educationComponent: EducationComponent;
    @ViewChild('skillsComponent') skillsComponent: SkillsComponent;
    @ViewChild('referencesComponent') referencesComponent: ReferencesComponent;

    constructor(
        private router: Router,
        private personalDetailsService: PersonalDetailsService,
        private utilsService: UtilsService,
        private activatedRoute: ActivatedRoute
    ) {
        super();
    }

    ngOnInit() {
        this.activatedRoute.params
            .pipe(takeUntil(this.componentInView))
            .subscribe(params => {
                if (params.screen) {
                    this.activeTab = params.screen;
                }
            });
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.personalDetailsService.getCareerProfile()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.careerProfile = response;
            }, err => {
                this.isLoading = false;
                this.utilsService.handleError(err);
            })
    }

    exit(): void {
        switch (this.activeTab) {
            case 'personal-data':
                this.personalDetailsComponent.updateProfile('/my-career-web/dashboard/home');
                break;
            case 'work-history':
                this.workHistoryComponent.saveWorkHistory('/my-career-web/dashboard/home');
                break;
            case 'education':
                this.educationComponent.saveEducation('/my-career-web/dashboard/home');
                break;
            case 'skills':
                this.skillsComponent.saveSkill('/my-career-web/dashboard/home');
                break;
            case 'references':
                this.referencesComponent.saveReferees('/my-career-web/dashboard/home');
                break;
            default:
                this.router.navigate([['/my-career-web/dashboard/home']]);
        }
    }

    tabChanged($event): void {
        this.router.navigate([`/my-career-web/career-history/${this.tabs[$event.index]}`]);
    }

}
