import { Injectable } from '@angular/core';
import { UtilsService } from '../../oneit/services/utils.service';
import { SearchService } from '../../oneit/services/search.service';
import { Observable } from 'rxjs';
import { SERVICES } from '../config/constants';
import { SaveService } from '../../oneit/services/save.service';
import { IntroductionLetterModel } from '../models/introduction-letter.model';

@Injectable()
export class IntroLetterService {

    constructor(
        private utilsService: UtilsService,
        private searchService: SearchService,
        private saveService: SaveService
    ) {
    }


    getIntroLetters(queryParams = {}, assocs = []): Observable<any> {
        return this.searchService.getObjects(SERVICES.INTRODUCTION_LETTERS, 'All', queryParams, assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            )
    }

    getIntroLetter(id, assocs = []): Observable<IntroductionLetterModel> {
        return this.searchService.getObjects(SERVICES.INTRODUCTION_LETTERS, 'ByID', {id: id}, assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs)[0];
                }
            )
    }

    downloadIntroLetter(id): Observable<any> {
        return this.searchService.downloadDocument(SERVICES.INTRODUCTION_LETTERS, id, 'IntroductionLetterPDF', null)
            .map(
                data => {
                    return data;
                }
            )
    }

    saveIntroLetters(createdObjs, updatedObjs, deleteObjs): Observable<any> {
        return this.saveService.saveObjectsWithDefaultSvc(createdObjs, updatedObjs, deleteObjs);
    }

}
